/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelectorList;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.componentdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class ComponentModify
extends SessionBase {
    private static CommandHelp sHelp = new ComponentModifyHelp();
    private ComponentID mComp;
    private String mLabel;
    private String mDescription;
    private String[] mResourceVersions = null;
    private Component mResult;
    private boolean mHidePrevious = true;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentModify;

    public void setComponent(ComponentID comp) {
        this.mComp = comp;
    }

    public ComponentID getComponent() {
        return this.mComp;
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setResourceVersions(String[] resourceVersions) {
        this.mResourceVersions = resourceVersions;
    }

    public String[] getResourceVersions() {
        return this.mResourceVersions;
    }

    public boolean getHidePrevious() {
        return this.mHidePrevious;
    }

    public void setHidePrevious(boolean hidePrevious) {
        this.mHidePrevious = hidePrevious;
    }

    protected void setResult(Component result) {
        this.mResult = result;
    }

    public Component getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        SummaryComponent latestComponent;
        ComponentDescriptor cd = ComponentDescriptor.create(this.getComponent());
        if (this.getLabel() != null) {
            cd.setLabel(this.getLabel());
        }
        if (this.getDescription() != null) {
            cd.setDescription(this.getDescription());
        }
        if (cd.isSimpleComponent()) {
            if (this.getResourceVersions() != null) {
                throw PackageInfo.throwResourceVersionsNotRequired();
            }
        } else {
            ResourceSelectorList rs = cd.getResourceSelectors();
            if (this.getResourceVersions() != null && rs.size() != this.getResourceVersions().length) {
                PackageInfo.throwIllegalNumberOfResources(rs.size());
            }
            String[] rvs = this.getResourceVersions();
            for (int i = 0; i < rs.size(); ++i) {
                int index;
                ResourceSelector rsi = rs.getSelector(i);
                if (rvs == null) {
                    index = rsi.getIndexOfLatest();
                } else if (rvs[i].equals("#")) {
                    index = rsi.getIndexOfRecommended();
                } else if (rvs[i].equals("-")) {
                    index = rsi.getIndexOfLatest();
                } else if (rvs[i].equals("+")) {
                    index = rsi.getIndexOfDefault();
                } else {
                    VersionNumber v = new VersionNumber(rvs[i]);
                    index = rsi.getIndexOfVersion(v);
                }
                if (index == -1) {
                    PackageInfo.throwCannotResolveResource(i, rsi.getName());
                }
                if (rsi.isReadOnly()) continue;
                rsi.setIndexOfCurrent(index);
            }
        }
        Component comp = cd.generateComponent();
        ComponentSaveContext ctx = new ComponentSaveContext();
        try {
            SingleComponentQuery scq = SingleComponentQuery.byName(comp.getPath(), comp.getName(), null);
            latestComponent = scq.selectSummaryView();
        }
        catch (NoResultsFoundException ex) {
            latestComponent = comp;
        }
        ctx.setLatestVersion(latestComponent);
        ctx.setHideLatest(this.mHidePrevious);
        ctx.setImportSettings(true);
        comp.save(ctx);
        this.setResult(comp);
    }

    protected static class ComponentModifyHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cdb.c.mod";
        private static final String MSG_COMP_DESC = "KEY:ui.cdb.c.mod.COMP_DESC";
        private static final String MSG_LABEL_DESC = "KEY:ui.cdb.c.mod.LABEL_DESC";
        private static final String MSG_DESCRIPTION_DESC = "KEY:ui.cdb.c.mod.DESCRIPTION_DESC";
        private static final String MSG_RESOURCEVERSIONS_DESC = "KEY:ui.cdb.c.mod.RESOURCEVERSIONS_DESC";
        private static final String MSG_HIDEPREV_DESC = "KEY:ui.cdb.c.mod.HIDEPREV_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.cdb.c.mod.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.cdb.c.mod.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("component", MSG_COMP_DESC, "comp"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("label", MSG_LABEL_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("description", MSG_DESCRIPTION_DESC, "desc"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("resourceVersions", MSG_RESOURCEVERSIONS_DESC, "rva"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("hidePrevious", MSG_HIDEPREV_DESC, "hidePrev"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        ComponentModifyHelp() {
            super(class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentModify == null ? (class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentModify = ComponentModify.class$("com.raplix.rolloutexpress.ui.componentdb.commands.ComponentModify")) : class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentModify, MSG_COMMAND_DESC);
        }
    }
}

