/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class ComponentList
extends SessionBase {
    private static CommandHelp sHelp = new ComponentListHelp();
    private SummaryComponent[] mResult;
    private boolean mShowHidden = false;
    private CategoryID mCategoryFilter = null;
    private FolderID mFolderID = FolderID.ROOT_FOLDER_ID;
    private boolean mFlatView = true;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentList;

    public boolean getShowHidden() {
        return this.mShowHidden;
    }

    public void setShowHidden(boolean showHidden) {
        this.mShowHidden = showHidden;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID inFilter) {
        this.mCategoryFilter = inFilter;
    }

    public FolderID getFolderID() {
        return this.mFolderID;
    }

    public void setFolderID(FolderID folderID) {
        this.mFolderID = folderID;
    }

    public boolean getFlatView() {
        return this.mFlatView;
    }

    public void setFlatView(boolean flatView) {
        this.mFlatView = flatView;
    }

    protected void setResult(SummaryComponent[] result) {
        this.mResult = result;
    }

    public SummaryComponent[] getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        MultiComponentQuery query = MultiComponentQuery.all();
        query.setVisibilityFilter(this.getShowHidden() ? null : Visibility.VISIBLE);
        query.setCategoryFilter(this.getCategoryFilter());
        FullPathFilter pathFilter = new FullPathFilter();
        pathFilter.setRecursiveMode(this.getFlatView());
        pathFilter.setSearchRoot(this.getFolderID());
        query.setFullPathFilter(pathFilter);
        this.setResult(query.selectSummaryView());
    }

    protected static class ComponentListHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cdb.c.la.";
        private static final String MSG_SHOW_HIDDEN_DESC = "KEY:ui.cdb.c.la.SHOW_HIDDEN_DESC";
        private static final String MSG_CATEGORY_FILTER_DESC = "KEY:ui.cdb.c.la.CATEGORY_FILTER_DESC";
        private static final String MSG_PARENT_FOLDER_DESC = "KEY:ui.cdb.c.la.PARENT_FOLDER_DESC";
        private static final String MSG_FLATVIEW_DESC = "KEY:ui.cdb.c.la.FLATVIEW_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.cdb.c.la.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.cdb.c.la.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.OptionalArgInfo("showHidden", MSG_SHOW_HIDDEN_DESC, "sh"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("categoryFilter", MSG_CATEGORY_FILTER_DESC, "cat"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("folderID", MSG_PARENT_FOLDER_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("flatView", MSG_FLATVIEW_DESC));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        ComponentListHelp() {
            super(class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentList == null ? (class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentList = ComponentList.class$("com.raplix.rolloutexpress.ui.componentdb.commands.ComponentList")) : class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentList, MSG_COMMAND_DESC);
        }
    }
}

