/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import java.io.InputStream;
import java.util.Vector;

public class ComponentCheckin
extends SessionBase {
    private static CommandHelp sHelp = new ComponentCheckinHelp();
    private Closer mCloser = new Closer();
    private InputStreamWrapper mCompXMLStream;
    private Component mResult;
    private boolean mIsMajor = false;
    private boolean mImportVarSettings = true;
    private boolean mHidePrevious = true;
    private boolean mParents = false;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentCheckin;

    public InputStreamWrapper getCompXMLStream() {
        return this.mCompXMLStream;
    }

    public void setCompXMLStream(InputStreamWrapper compXMLStream) {
        this.mCompXMLStream = compXMLStream;
        this.mCloser.register(this.mCompXMLStream);
    }

    public boolean getCheckinAsMajorVersion() {
        return this.mIsMajor;
    }

    public void setCheckinAsMajorVersion(boolean isMajor) {
        this.mIsMajor = isMajor;
    }

    public boolean getImportVarSettings() {
        return this.mImportVarSettings;
    }

    public void setImportVarSettings(boolean importVarSettings) {
        this.mImportVarSettings = importVarSettings;
    }

    public boolean getHidePrevious() {
        return this.mHidePrevious;
    }

    public void setHidePrevious(boolean hidePrevious) {
        this.mHidePrevious = hidePrevious;
    }

    public Component getResult() {
        return this.mResult;
    }

    protected void setResult(Component result) {
        this.mResult = result;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        InputStream in = this.getCompXMLStream().getStream();
        ComponentSaveContext ctx = new ComponentSaveContext();
        ctx.setSaveAsNewMajor(this.getCheckinAsMajorVersion());
        ctx.setImportSettings(this.getImportVarSettings());
        ctx.setHideLatest(this.getHidePrevious());
        this.setResult(Context.getComponentIO().createNewVersionFrom(in, ctx, this.mParents));
    }

    public void cleanup() {
        super.cleanup();
        this.mCloser.closeAll();
    }

    public boolean getParents() {
        return this.mParents;
    }

    public void setParents(boolean parents) {
        this.mParents = parents;
    }

    protected static class ComponentCheckinHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cdb.c.ci.";
        private static final String MSG_PATH_DESC = "KEY:ui.cdb.c.ci.PATH_DESC";
        private static final String MSG_CHECKINASMAJOR_DESC = "KEY:ui.cdb.c.ci.CHECKINASMAJOR_DESC";
        private static final String MSG_IMPORTVARS_DESC = "KEY:ui.cdb.c.ci.IMPORTVARS_DESC";
        private static final String MSG_HIDEPREV_DESC = "KEY:ui.cdb.c.ci.HIDEPREV_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.cdb.c.ci.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.cdb.c.ci.COMMAND_DESC";
        private static final String MSG_PARENTS_DESC = "KEY:ui.cdb.c.ci.PARENTS_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("compXMLStream", MSG_PATH_DESC, "path"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("checkinAsMajorVersion", MSG_CHECKINASMAJOR_DESC, "major"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("importVarSettings", MSG_IMPORTVARS_DESC, "import"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("hidePrevious", MSG_HIDEPREV_DESC, "hidePrev"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("parents", MSG_PARENTS_DESC, "parents"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        ComponentCheckinHelp() {
            super(class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentCheckin == null ? (class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentCheckin = ComponentCheckin.class$("com.raplix.rolloutexpress.ui.componentdb.commands.ComponentCheckin")) : class$com$raplix$rolloutexpress$ui$componentdb$commands$ComponentCheckin, MSG_COMMAND_DESC);
        }
    }
}

