/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.Command;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.CommandWrapper;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.commands.MethodCommand;
import com.raplix.rolloutexpress.ui.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.formatters.FormatterRepository;
import com.raplix.util.DelayedCreator;
import com.raplix.util.reflect.ClassUtil;
import com.raplix.util.string.StringUtil;
import org.w3c.dom.Node;

public class RepositoryEntry
implements CommandWrapper {
    private static final String ATTR_IMPLEMENTATION = "implementation";
    private static final String ATTR_SHORTHAND = "shorthand";
    private static final String ATTR_DEFAULT_OUTPUT = "defaultoutput";
    private Node mNode;
    private HelpCreator mHelp = new HelpCreator();
    private String mName;
    private String mShorthand;
    private String mDefaultOutput;
    private RepositoryCreator mRepository = new RepositoryCreator();

    public RepositoryEntry(Node node) {
        Node defaultOutput;
        this.mName = node.getAttributes().getNamedItem(ATTR_IMPLEMENTATION).getNodeValue();
        this.mNode = node;
        Node shorthand = node.getAttributes().getNamedItem(ATTR_SHORTHAND);
        if (shorthand != null) {
            this.mShorthand = shorthand.getNodeValue();
        }
        if ((defaultOutput = node.getAttributes().getNamedItem(ATTR_DEFAULT_OUTPUT)) != null) {
            this.mDefaultOutput = defaultOutput.getNodeValue();
        }
    }

    public RepositoryEntry(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setShorthand(String shorthand) {
        this.mShorthand = shorthand;
    }

    public void setFormatterRepository(FormatterRepository repository) {
        this.mRepository.setValue(repository);
    }

    public FormatterRepository getFormatterRepository() {
        return (FormatterRepository)this.mRepository.getValue();
    }

    public String getName() {
        return this.mName;
    }

    public String getShorthand() {
        return this.mShorthand;
    }

    public CommandHelp getHelp() {
        return (CommandHelp)this.mHelp.getValue();
    }

    public Command getCommand() {
        try {
            return (Command)ClassUtil.createObject(this.mName, Command.class);
        }
        catch (NoClassDefFoundError ex1) {
            try {
                return new MethodCommand(this.mName);
            }
            catch (Throwable ex2) {
                PackageInfo.throwUnknownCommand(this.mName);
                return null;
            }
        }
    }

    public Formatter getFormatter(String name) {
        return this.getFormatterRepository().getFormatter(name);
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        if (this.getShorthand() != null) {
            buffer.append("<shorthand>");
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append(this.getShorthand());
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append("</shorthand>");
            buffer.append(StringUtil.LINE_SEPARATOR);
        }
        buffer.append(this.getHelp().toXML());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.getFormatterRepository().toXML());
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getShorthand() != null) {
            buffer.append("Shorthand:");
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append(" ");
            buffer.append(this.getShorthand());
            buffer.append(StringUtil.LINE_SEPARATOR);
        }
        buffer.append(this.getHelp());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.getFormatterRepository());
        return buffer.toString();
    }

    private class HelpCreator
    extends DelayedCreator {
        private HelpCreator() {
        }

        protected Object create() {
            return RepositoryEntry.this.getCommand().getHelp();
        }
    }

    private class RepositoryCreator
    extends DelayedCreator {
        private RepositoryCreator() {
        }

        protected Object create() {
            FormatterRepository r = new FormatterRepository();
            if (RepositoryEntry.this.mDefaultOutput != null) {
                r.setDefaultFormatterName(RepositoryEntry.this.mDefaultOutput);
            }
            if (RepositoryEntry.this.mNode != null) {
                r.addFormatters(RepositoryEntry.this.mNode);
            }
            r.addDefaultFormatters();
            return r;
        }
    }
}

