/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.CommandWrapper;
import com.raplix.rolloutexpress.ui.commands.ListAuthorizerClause;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class REAuthorizerClause
implements ListAuthorizerClause {
    private static final String ATTR_SHORTHAND = "shorthand";
    private static final String ATTR_IMPLEMENTATION = "implementation";
    private boolean mShorthand;
    private String mRawPattern;
    private RegEx mPattern;

    public REAuthorizerClause(Node node) {
        NamedNodeMap attr = node.getAttributes();
        Node shorthand = attr.getNamedItem(ATTR_SHORTHAND);
        this.setShorthand(shorthand != null);
        String pattern = this.getShorthand() ? shorthand.getNodeValue() : attr.getNamedItem(ATTR_IMPLEMENTATION).getNodeValue();
        this.setPattern("^" + pattern + "$");
    }

    public REAuthorizerClause(boolean shorthand, String pattern) {
        this.setShorthand(shorthand);
        this.setPattern(pattern);
    }

    public void setShorthand(boolean shorthand) {
        this.mShorthand = shorthand;
    }

    public boolean getShorthand() {
        return this.mShorthand;
    }

    public void setPattern(String pattern) {
        this.mRawPattern = pattern;
        this.mPattern = REUtil.compilePattern(this.mRawPattern);
    }

    public String getPattern() {
        return this.mRawPattern;
    }

    public boolean matches(CommandWrapper wrapper) {
        if (this.getShorthand()) {
            if (wrapper.getShorthand() == null) {
                return false;
            }
            return this.mPattern.match(wrapper.getShorthand());
        }
        return this.mPattern.match(wrapper.getName());
    }

    public String toString() {
        return "Pattern: " + this.getPattern();
    }
}

