/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.Context;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "ui.commands";
    public static final String EX_MALFORMED_METHOD_NAME = "ui.commands.EX_MALFORMED_METHOD_NAME";
    public static final String EX_CANNOT_INTROSPECT = "ui.commands.EX_CANNOT_INTROSPECT";
    public static final String EX_UNKNOWN_COMMAND = "ui.commands.EX_UNKNOWN_COMMAND";
    public static final String EX_COMMAND_NOT_ALLOWED = "ui.commands.EX_COMMAND_NOT_ALLOWED";
    public static final String EX_UNKNOWN_PROPERTY = "ui.commands.EX_UNKNOWN_PROPERTY";

    private PackageInfo() {
    }

    public static void throwMalformedMethodName(String name) {
        throw new IllegalArgumentException(Context.getMessageText(EX_MALFORMED_METHOD_NAME, name));
    }

    public static void throwCannotIntrospect(Class cls, Exception ex) {
        String message = Context.getMessageText(EX_CANNOT_INTROSPECT, cls.getName(), ex.getMessage());
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        throw new IllegalArgumentException(message);
    }

    public static void throwUnknownCommand(String name) {
        throw new IllegalArgumentException(Context.getMessageText(EX_UNKNOWN_COMMAND, name));
    }

    public static void throwCommandNotAllowed(String name) {
        throw new AccessControlException(Context.getMessageText(EX_COMMAND_NOT_ALLOWED, name));
    }

    public static void throwUnknownProperty(String name) {
        throw new IllegalArgumentException(Context.getMessageText(EX_UNKNOWN_PROPERTY, name));
    }
}

