/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.ArgumentDescriptor;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.ResultDescriptor;
import com.raplix.rolloutexpress.ui.commands.MethodArgumentDescriptor;
import com.raplix.rolloutexpress.ui.commands.MethodReceiverDescriptor;
import com.raplix.rolloutexpress.ui.commands.MethodResultDescriptor;
import com.raplix.util.string.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodCommandHelp
implements CommandHelp {
    private ArgumentDescriptor[] mArguments;
    private ResultDescriptor mResult;
    private String mDesc;
    private String mSyntax;

    public MethodCommandHelp(Method method) {
        boolean isMember;
        String methodName = method.getName();
        String className = method.getDeclaringClass().getName();
        this.mDesc = "Method '" + methodName + "' in class '" + className + "'";
        this.mSyntax = className + "." + methodName;
        Class<?>[] argClass = method.getParameterTypes();
        int argCount = argClass.length;
        boolean bl = isMember = !Modifier.isStatic(method.getModifiers());
        if (isMember) {
            ++argCount;
        }
        this.mArguments = new ArgumentDescriptor[argCount];
        if (isMember) {
            this.mArguments[--argCount] = new MethodReceiverDescriptor(method.getDeclaringClass());
        }
        while (argCount > 0) {
            this.mArguments[--argCount] = new MethodArgumentDescriptor(argCount, argClass[argCount]);
        }
        this.mResult = new MethodResultDescriptor(method.getReturnType());
    }

    public String getDescription() {
        return this.mDesc;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.mArguments;
    }

    public ResultDescriptor getResultDescriptor() {
        return this.mResult;
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<command>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("<description>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.getDescription());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("</description>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("<fullSyntax>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.mSyntax);
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("</fullSyntax>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        ArgumentDescriptor[] args = this.getArgumentDescriptors();
        if (args != null) {
            buffer.append("<arguments>");
            buffer.append(StringUtil.LINE_SEPARATOR);
            for (int i = 0; i < args.length; ++i) {
                buffer.append(args[i].toXML());
                buffer.append(StringUtil.LINE_SEPARATOR);
            }
            buffer.append("</arguments>");
            buffer.append(StringUtil.LINE_SEPARATOR);
        }
        if (this.getResultDescriptor() != null) {
            buffer.append(this.getResultDescriptor().toXML());
            buffer.append(StringUtil.LINE_SEPARATOR);
        }
        buffer.append("</command>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Description:");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(" ");
        buffer.append(this.getDescription());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Full syntax:");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(" ");
        buffer.append(this.mSyntax);
        ArgumentDescriptor[] args = this.getArgumentDescriptors();
        if (args != null) {
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append("Arguments:");
            for (int i = 0; i < args.length; ++i) {
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append(" ");
                buffer.append(args[i]);
            }
        }
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Result:");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(" ");
        buffer.append(this.getResultDescriptor());
        return buffer.toString();
    }
}

