/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandBase;
import com.raplix.rolloutexpress.ui.commands.MethodCommandHelp;
import com.raplix.rolloutexpress.ui.commands.PackageInfo;
import com.raplix.util.reflect.ClassUtil;
import com.raplix.util.reflect.MethodUtil;
import java.lang.reflect.Method;

public class MethodCommand
extends CommandBase {
    private Method mMethod;
    private Object mReceiver;
    private Object[] mArguments;
    private Object mResult;
    private MethodCommandHelp mHelp;

    private void setMethod(Method method) {
        this.mMethod = method;
        this.mHelp = new MethodCommandHelp(this.mMethod);
        this.mArguments = new Object[this.mMethod.getParameterTypes().length];
    }

    private void setMethod(Class cls, String methodName) {
        this.setMethod(MethodUtil.findMethod(cls, methodName));
    }

    private void setMethod(String className, String methodName) {
        this.setMethod(ClassUtil.findClass(className), methodName);
    }

    public MethodCommand(Method method) {
        this.setMethod(method);
    }

    public MethodCommand(Class cls, String methodName) {
        this.setMethod(cls, methodName);
    }

    public MethodCommand(String className, String methodName) {
        this.setMethod(className, methodName);
    }

    public MethodCommand(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            PackageInfo.throwMalformedMethodName(name);
        }
        this.setMethod(name.substring(0, index), name.substring(index + 1));
    }

    public void setReceiver(Object receiver) {
        this.mReceiver = receiver;
    }

    public Object getReceiver() {
        return this.mReceiver;
    }

    public void setArgument(int index, Object value) {
        this.mArguments[index] = value;
    }

    public Object getArgument(int index) {
        return this.mArguments[index];
    }

    public void setResult(Object result) {
        this.mResult = result;
    }

    public Object getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return this.mHelp;
    }

    public void execute() throws Exception {
        this.setResult(MethodUtil.invoke(this.mMethod, this.mReceiver, this.mArguments));
    }
}

