/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.Authorizer;
import com.raplix.rolloutexpress.ui.CommandWrapper;
import com.raplix.rolloutexpress.ui.commands.ListAuthorizerClause;
import com.raplix.rolloutexpress.ui.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.commands.REAuthorizerClause;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.logger.Logger;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListAuthorizer
implements Authorizer {
    private static final String ELEM_ALLOW = "allow";
    private static final String ELEM_DENY = "deny";
    private static final String ATTR_ORDER = "order";
    private static final String VAL_TYPE_DENYALLOW = "deny,allow";
    private static final String VAL_TYPE_ALLOWDENY = "allow,deny";
    private boolean mAllowDeny = false;
    private Vector mAllow = new Vector();
    private Vector mDeny = new Vector();

    public ListAuthorizer(Node node) {
        Node order = node.getAttributes().getNamedItem(ATTR_ORDER);
        if (order != null) {
            this.setAllowDeny(VAL_TYPE_ALLOWDENY.equals(order.getNodeValue()));
        }
        DOMElementEnumeration e = new DOMElementEnumeration(node);
        while (e.hasMoreElements()) {
            Element clauseNode = e.nextElement();
            REAuthorizerClause c = new REAuthorizerClause(clauseNode);
            if (ELEM_ALLOW.equals(clauseNode.getNodeName())) {
                this.addAllow(c);
                continue;
            }
            this.addDeny(c);
        }
    }

    public ListAuthorizer() {
    }

    public void setAllowDeny(boolean allowDeny) {
        this.mAllowDeny = allowDeny;
    }

    public boolean getAllowDeny() {
        return this.mAllowDeny;
    }

    private boolean checkMatch(Vector list, CommandWrapper wrapper) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            if (!((ListAuthorizerClause)e.nextElement()).matches(wrapper)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAllowMatch(CommandWrapper wrapper) {
        return this.checkMatch(this.mAllow, wrapper);
    }

    private boolean checkDenyMatch(CommandWrapper wrapper) {
        return this.checkMatch(this.mDeny, wrapper);
    }

    public void addAllow(ListAuthorizerClause c) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Adding allow '" + c + "'", this);
        }
        this.mAllow.addElement(c);
    }

    public void addDeny(ListAuthorizerClause c) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Adding deny '" + c + "'", this);
        }
        this.mDeny.addElement(c);
    }

    public void authorize(CommandWrapper wrapper) {
        boolean allowed;
        if (this.getAllowDeny()) {
            allowed = this.checkAllowMatch(wrapper) && !this.checkDenyMatch(wrapper);
        } else {
            boolean bl = allowed = this.checkAllowMatch(wrapper) || !this.checkDenyMatch(wrapper);
        }
        if (!allowed) {
            PackageInfo.throwCommandNotAllowed(wrapper.getName());
        }
    }
}

