/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import [Ljava.lang.String;;
import com.raplix.rolloutexpress.ui.CommandWrapper;
import com.raplix.rolloutexpress.ui.commands.RepositoryEntry;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;

public class CommandRepository {
    private Hashtable mEntries = new Hashtable();

    public CommandRepository(Node node) {
        DOMElementEnumeration e = new DOMElementEnumeration(node);
        while (e.hasMoreElements()) {
            this.addCommandWrapper(new RepositoryEntry(e.nextElement()));
        }
    }

    public CommandRepository() {
    }

    public void addCommandWrapper(CommandWrapper entry) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Adding '" + entry.getName() + "'", this);
        }
        this.mEntries.put(entry.getName(), entry);
        if (entry.getShorthand() != null) {
            this.mEntries.put(entry.getShorthand(), entry);
        }
    }

    public CommandWrapper getCommandWrapper(String name) {
        CommandWrapper w;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Asked for '" + name + "'", this);
        }
        if ((w = (CommandWrapper)this.mEntries.get(name)) != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Found '" + w.getName() + "'", this);
            }
            return w;
        }
        w = new RepositoryEntry(name);
        this.addCommandWrapper(w);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Created '" + w + "'", this);
        }
        return w;
    }

    public String[] getMatchingNames(String pattern) {
        Vector<String> names = new Vector<String>();
        RegEx re = REUtil.compileWildcard(pattern);
        Enumeration e = this.mEntries.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!re.match(name)) continue;
            names.addElement(name);
        }
        return (String[])CollectionUtil.mapClass(names, String;.class);
    }
}

