/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.ArgumentDescriptor;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ResultDescriptor;
import com.raplix.rolloutexpress.ui.commands.ArgumentDescriptorBase;
import com.raplix.rolloutexpress.ui.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.commands.ResultDescriptorBase;
import com.raplix.util.string.StringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Enumeration;
import java.util.Vector;

public class CommandHelpBase
implements CommandHelp {
    public static final String KEY_PREFIX = "KEY:";
    private ArgumentDescriptor[] mArguments;
    private ResultDescriptor mResult;
    private String mDesc;
    private BeanInfo mBeanInfo;

    private static String getDescription(String desc) {
        if (desc.startsWith(KEY_PREFIX)) {
            return Context.getMessageText(desc.substring(KEY_PREFIX.length()));
        }
        return desc;
    }

    protected Vector getArgumentMap() {
        return new Vector();
    }

    protected ResultInfo getResultMap() {
        return null;
    }

    protected void setDescription(String desc) {
        this.mDesc = desc;
    }

    public CommandHelpBase(Class cls, String desc) {
        ResultInfo entry;
        try {
            this.mBeanInfo = Introspector.getBeanInfo(cls);
        }
        catch (IntrospectionException ex) {
            PackageInfo.throwCannotIntrospect(cls, ex);
        }
        this.setDescription(CommandHelpBase.getDescription(desc));
        Vector map = this.getArgumentMap();
        if (map.size() > 0) {
            this.mArguments = new ArgumentDescriptorBase[map.size()];
            Enumeration e = map.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                ArgInfo entry2 = (ArgInfo)e.nextElement();
                this.mArguments[i] = new ArgumentDescriptorBase(entry2.mName, this.mBeanInfo, entry2.mDesc, entry2.mTag, entry2.mOptional);
                ++i;
            }
        }
        if ((entry = this.getResultMap()) != null) {
            this.mResult = new ResultDescriptorBase(entry.mName, this.mBeanInfo, entry.mDesc);
        }
    }

    public String getDescription() {
        return this.mDesc;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.mArguments;
    }

    public ResultDescriptor getResultDescriptor() {
        return this.mResult;
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<command>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("<description>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.getDescription());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("</description>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("<fullSyntax>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.mBeanInfo.getBeanDescriptor().getBeanClass().getName());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("</fullSyntax>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        ArgumentDescriptor[] args = this.getArgumentDescriptors();
        if (args != null) {
            buffer.append("<arguments>");
            buffer.append(StringUtil.LINE_SEPARATOR);
            for (int i = 0; i < args.length; ++i) {
                buffer.append(args[i].toXML());
                buffer.append(StringUtil.LINE_SEPARATOR);
            }
            buffer.append("</arguments>");
            buffer.append(StringUtil.LINE_SEPARATOR);
        }
        if (this.getResultDescriptor() != null) {
            buffer.append(this.getResultDescriptor().toXML());
            buffer.append(StringUtil.LINE_SEPARATOR);
        }
        buffer.append("</command>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Description:");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(" ");
        buffer.append(this.getDescription());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Full syntax:");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(" ");
        buffer.append(this.mBeanInfo.getBeanDescriptor().getBeanClass().getName());
        ArgumentDescriptor[] args = this.getArgumentDescriptors();
        if (args != null) {
            buffer.append(StringUtil.LINE_SEPARATOR + "Arguments:");
            for (int i = 0; i < args.length; ++i) {
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append(" ");
                buffer.append(args[i]);
            }
        }
        if (this.getResultDescriptor() != null) {
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append("Result:");
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append(" ");
            buffer.append(this.getResultDescriptor());
        }
        return buffer.toString();
    }

    protected static class ResultInfo {
        public String mName;
        public String mDesc;

        public ResultInfo(String name, String desc) {
            this.mName = name;
            this.mDesc = CommandHelpBase.getDescription(desc);
        }
    }

    protected static class RequiredPossiblyArgInfo
    extends ArgInfo {
        public RequiredPossiblyArgInfo(String name, String desc) {
            super(name, desc, 2);
        }

        public RequiredPossiblyArgInfo(String name, String desc, String tag) {
            super(name, desc, tag, 2);
        }
    }

    protected static class OptionalArgInfo
    extends ArgInfo {
        public OptionalArgInfo(String name, String desc) {
            super(name, desc, 1);
        }

        public OptionalArgInfo(String name, String desc, String tag) {
            super(name, desc, tag, 1);
        }
    }

    protected static class RequiredArgInfo
    extends ArgInfo {
        public RequiredArgInfo(String name, String desc) {
            super(name, desc, 0);
        }

        public RequiredArgInfo(String name, String desc, String tag) {
            super(name, desc, tag, 0);
        }
    }

    private static class ArgInfo {
        String mName;
        String mDesc;
        String mTag;
        int mOptional;

        ArgInfo(String name, String desc, int optional) {
            this.mName = name;
            this.mDesc = CommandHelpBase.getDescription(desc);
            this.mTag = name;
            this.mOptional = optional;
        }

        ArgInfo(String name, String desc, String tag, int optional) {
            this.mName = name;
            this.mDesc = CommandHelpBase.getDescription(desc);
            this.mTag = tag;
            this.mOptional = optional;
        }
    }
}

