/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.commands;

import com.raplix.rolloutexpress.ui.ArgumentDescriptor;
import com.raplix.rolloutexpress.ui.Command;
import com.raplix.rolloutexpress.ui.commands.CommandElementDescriptorBase;
import com.raplix.util.reflect.ClassUtil;
import com.raplix.util.reflect.MethodUtil;
import com.raplix.util.string.StringUtil;
import java.beans.BeanInfo;

public class ArgumentDescriptorBase
extends CommandElementDescriptorBase
implements ArgumentDescriptor {
    private String mTag;
    private int mOptional;

    public ArgumentDescriptorBase(String name, BeanInfo beanInfo, String desc, String tag, int optional) {
        super(name, beanInfo, desc);
        this.mTag = tag;
        this.mOptional = optional;
    }

    public String getTag() {
        return this.mTag;
    }

    public int getOptional() {
        return this.mOptional;
    }

    public void set(Command command, Object value) throws Exception {
        MethodUtil.invokeMember(this.getPropertyDescriptor().getWriteMethod(), command, value);
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<argument>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("<tag need=\"");
        if (this.getOptional() == 1) {
            buffer.append("optional");
        } else if (this.getOptional() == 2) {
            buffer.append("possibly");
        } else if (this.getOptional() == 0) {
            buffer.append("required");
        }
        buffer.append("\">");
        buffer.append(this.getTag());
        buffer.append("</tag>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("<description>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.getDescription());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("</description>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("<class>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(ClassUtil.getClassName(this.getType()));
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("</class>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("</argument>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("-");
        buffer.append(this.getTag());
        if (this.getOptional() == 1) {
            buffer.append(" [O]");
        } else if (this.getOptional() == 2) {
            buffer.append(" [O/R]");
        }
        buffer.append(": ");
        buffer.append(this.getDescription());
        buffer.append(": ");
        buffer.append(ClassUtil.getClassName(this.getType()));
        return buffer.toString();
    }
}

