/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.clui;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ui.Context;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "ui.clui";
    public static final String EX_MISSING_COMMAND_NAME = "ui.clui.EX_MISSING_COMMAND_NAME";
    public static final String EX_MISSING_OUTPUT_FORMAT = "ui.clui.EX_MISSING_OUTPUT_FORMAT";
    public static final String EX_MISSING_OUTPUT_FILE = "ui.clui.EX_MISSING_OUTPUT_FILE";
    public static final String EX_REPEATED_ARGUMENT = "ui.clui.EX_REPEATED_ARGUMENT";
    public static final String EX_MISSING_ARGUMENT_TAG = "ui.clui.EX_MISSING_ARGUMENT_TAG";
    public static final String EX_MISSING_ARGUMENT_VALUE = "ui.clui.EX_MISSING_ARGUMENT_VALUE";
    public static final String EX_CIRCULAR_REFERENCE = "ui.clui.EX_CIRCULAR_REFERENCE";
    public static final String EX_STDIN_OVERUSED = "ui.clui.EX_STDIN_OVERUSED";
    public static final String EX_REGISTRATION_FAILED = "ui.clui.EX_REGISTRATION_FAILED";

    private PackageInfo() {
    }

    public static void throwMissingCommandName() {
        throw new IllegalArgumentException(Context.getMessageText(EX_MISSING_COMMAND_NAME));
    }

    public static void throwMissingOutputFormat() {
        throw new IllegalArgumentException(Context.getMessageText(EX_MISSING_OUTPUT_FORMAT));
    }

    public static void throwMissingOutputFile() {
        throw new IllegalArgumentException(Context.getMessageText(EX_MISSING_OUTPUT_FILE));
    }

    public static void throwRepeatedArgument(String tag) {
        throw new IllegalArgumentException(Context.getMessageText(EX_REPEATED_ARGUMENT, tag));
    }

    public static void throwMissingArgumentTag(String arg) {
        throw new IllegalArgumentException(Context.getMessageText(EX_MISSING_ARGUMENT_TAG, arg));
    }

    public static void throwMissingArgumentValue(String tag) {
        throw new IllegalArgumentException(Context.getMessageText(EX_MISSING_ARGUMENT_VALUE, tag));
    }

    public static void throwCircularReference(String name) {
        throw new IllegalArgumentException(Context.getMessageText(EX_CIRCULAR_REFERENCE, name));
    }

    public static void throwStdinOverused() {
        throw new IllegalArgumentException(Context.getMessageText(EX_STDIN_OVERUSED));
    }

    public static void throwRegistrationFailed(Exception ex) throws ConfigurationException {
        throw new ConfigurationException(EX_REGISTRATION_FAILED, (Throwable)ex);
    }
}

