/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.clui;

import [Ljava.lang.String;;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.ui.CommandWrapper;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.clui.CLUI;
import com.raplix.rolloutexpress.ui.clui.PackageInfo;
import com.raplix.rolloutexpress.ui.converters.String2StringArray;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.file.XSLTUtil;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import com.raplix.util.iowrappers.OutputStreamWrapper;
import com.raplix.util.iowrappers.ReaderWrapper;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;

public class CLUISubsystem
extends Subsystem {
    private static final String ARG_LIST = "-l";
    private static final String ARG_LIST_FULL = "-lf";
    private static final String ARG_HELP_LIST = "-lh";
    private static final String ARG_HELP = "-h";
    private static final String ARG_OUTPUT_FORMAT = "-o";
    private static final String ARG_OUTPUT_FILE = "-of";
    private static final String EXPAND_ARG_PREFIX = "exp:";
    private static final String SERIAL_ARG_PREFIX = "ser:";
    private static final String FILE_ARG_PREFIX = "file:";
    private static final String START_LONG_ARG_LINE = ":START:";
    private static final String END_LONG_ARG_LINE = ":END:";
    private static final String LONG_FORM_PREFIX = "com.";
    private static final String CFG_PREFIX = "clui.";
    private static final String MSG_NO_MATCHES = "ui.clui.NO_MATCHES";
    private static final String MSG_LONG_HEADER = "ui.clui.LONG_HEADER";
    private static final String MSG_SHORT_HEADER = "ui.clui.SHORT_HEADER";
    private static final String MSG_COMMON_ARGS_HEADER = "ui.clui.COMMON_ARGS_HEADER";
    private static final String MSG_HELP_HELP = "ui.clui.HELP_HELP";
    private static final String MSG_OUTPUT_FORMAT_HELP = "ui.clui.OUTPUT_FORMAT_HELP";
    private static final String MSG_OUTPUT_FILE_HELP = "ui.clui.OUTPUT_FILE_HELP";

    public CLUISubsystem(CLUI app) throws ConfigurationException {
        super(app);
    }

    public CLUISubsystem() {
    }

    protected String getConfigurationPropertyPrefix() {
        return CFG_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(String name, Set expanded, Vector result, File path) throws FileNotFoundException, IOException {
        if (!name.startsWith(EXPAND_ARG_PREFIX)) {
            result.addElement(name);
            return;
        }
        if (!"-".equals(name = name.substring(EXPAND_ARG_PREFIX.length()))) {
            File file = new File(path, name);
            name = file.getCanonicalPath();
            path = file.getParentFile();
        } else if (System.in.available() == 0) {
            PackageInfo.throwStdinOverused();
        }
        if (expanded.contains(name)) {
            PackageInfo.throwCircularReference(name);
        }
        expanded.add(name);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Expanding '" + name + "'", this);
        }
        ReaderWrapper wrapper = new ReaderWrapper(name);
        try {
            String line;
            LineNumberReader expansion = new LineNumberReader(wrapper.getReader());
            String inProgress = null;
            while ((line = expansion.readLine()) != null) {
                if (line.equals(START_LONG_ARG_LINE)) {
                    inProgress = "";
                    continue;
                }
                if (line.equals(END_LONG_ARG_LINE)) {
                    this.expand(inProgress, expanded, result, path);
                    inProgress = null;
                    continue;
                }
                if (inProgress == null) {
                    this.expand(line, expanded, result, path);
                    continue;
                }
                if (inProgress.equals("")) {
                    inProgress = line;
                    continue;
                }
                inProgress = inProgress + StringUtil.LINE_SEPARATOR + line;
            }
        }
        finally {
            wrapper.close();
            expanded.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args) throws Exception {
        if (args == null) {
            PackageInfo.throwMissingCommandName();
            return;
        }
        Vector newArgs = new Vector();
        for (int i = 0; i < args.length; ++i) {
            this.expand(args[i], new HashSet(), newArgs, null);
        }
        args = (String[])CollectionUtil.mapClass(newArgs, String;.class);
        int nextArg = 0;
        if (args.length == 0) {
            PackageInfo.throwMissingCommandName();
            return;
        }
        if (args[nextArg].equals(ARG_LIST) || args[nextArg].equals(ARG_LIST_FULL)) {
            Object[] names;
            boolean shortForms = args[nextArg].equals(ARG_LIST);
            String pattern = ++nextArg < args.length ? args[nextArg] : "*";
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Retrieving list: '" + pattern + "'", this);
            }
            if ((names = Context.getUISubsystem().getWrapperNames(pattern)).length == 0) {
                System.out.println(Context.getMessageText(MSG_NO_MATCHES));
                return;
            }
            Arrays.sort(names);
            if (!shortForms) {
                System.out.println(Context.getMessageText(MSG_LONG_HEADER));
                for (int i = 0; i < names.length; ++i) {
                    if (!((String)names[i]).startsWith(LONG_FORM_PREFIX)) continue;
                    System.out.print(" ");
                    System.out.println((String)names[i]);
                }
            } else {
                System.out.println(Context.getMessageText(MSG_SHORT_HEADER));
                for (int i = 0; i < names.length; ++i) {
                    if (((String)names[i]).startsWith(LONG_FORM_PREFIX)) continue;
                    System.out.print(" ");
                    System.out.println((String)names[i]);
                }
            }
            return;
        }
        if (args[nextArg].equals(ARG_HELP_LIST)) {
            String pattern = ++nextArg < args.length ? args[nextArg++] : "*";
            String formatter = null;
            if (nextArg < args.length) {
                formatter = args[nextArg];
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Retrieving help list: '" + pattern + "' onto '" + formatter, this);
            }
            Object[] names = Context.getUISubsystem().getWrapperNames(pattern);
            Arrays.sort(names);
            StringBuffer buffer = new StringBuffer();
            buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            buffer.append(StringUtil.LINE_SEPARATOR);
            buffer.append("<listing>");
            buffer.append(StringUtil.LINE_SEPARATOR);
            for (int i = 0; i < names.length; ++i) {
                CommandWrapper cmd = Context.getUISubsystem().getCommandWrapper((String)names[i]);
                buffer.append("<command>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<commonArgs>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<argument>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<tag need=\"optional\">");
                buffer.append(ARG_HELP);
                buffer.append("</tag>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<description>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("Prints a help screen on the terminal");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</description>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</argument>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<argument>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<tag need=\"optional\">");
                buffer.append("-o &lt;formatter&gt;");
                buffer.append("</tag>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<description>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("Selects a formatter");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</description>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</argument>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<argument>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<tag need=\"optional\">");
                buffer.append("-of &lt;name&gt;");
                buffer.append("</tag>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("<description>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("Selects an output file");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</description>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</argument>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</commonArgs>");
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append(cmd.toXML());
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append("</command>");
                buffer.append(StringUtil.LINE_SEPARATOR);
            }
            buffer.append("</listing>");
            buffer.append(StringUtil.LINE_SEPARATOR);
            if (formatter == null) {
                System.out.print(buffer.toString());
                return;
            }
            System.out.println(XSLTUtil.transform(XSLTUtil.getTransformer(new StreamSource(formatter)), buffer.toString()));
            return;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing '" + args[nextArg] + "'", this);
        }
        CommandWrapper cmd = Context.getUISubsystem().getCommandWrapper(args[nextArg++]);
        String outputFormat = null;
        String outputName = "-";
        while (nextArg < args.length) {
            if (args[nextArg].equals(ARG_HELP)) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Retrieving help", this);
                }
                System.out.println(Context.getMessageText(MSG_COMMON_ARGS_HEADER));
                System.out.println(" -h" + Context.getMessageText(MSG_HELP_HELP));
                System.out.println(" -o" + Context.getMessageText(MSG_OUTPUT_FORMAT_HELP));
                System.out.println(" -of" + Context.getMessageText(MSG_OUTPUT_FILE_HELP));
                System.out.println(cmd.toString());
                return;
            }
            if (args[nextArg].equals(ARG_OUTPUT_FORMAT)) {
                if (++nextArg == args.length) {
                    PackageInfo.throwMissingOutputFormat();
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Output format '" + args[nextArg] + "'", this);
                }
                outputFormat = args[nextArg];
            } else {
                if (!args[nextArg].equals(ARG_OUTPUT_FILE)) break;
                if (++nextArg == args.length) {
                    PackageInfo.throwMissingOutputFile();
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Output file name '" + args[nextArg] + "'", this);
                }
                outputName = args[nextArg];
            }
            ++nextArg;
        }
        Hashtable<String, Object> arguments = new Hashtable<String, Object>();
        Closer closer = new Closer();
        OutputStreamWrapper outputWrapper = new OutputStreamWrapper(outputName);
        closer.register(outputWrapper);
        try {
            while (nextArg < args.length) {
                Object actualValue;
                String strValue;
                String arg;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Raw tag '" + args[nextArg] + "'", this);
                }
                if ((arg = args[nextArg++]).length() < 2) {
                    PackageInfo.throwMissingArgumentTag(arg);
                }
                String tag = arg.substring(1);
                if (nextArg == args.length) {
                    PackageInfo.throwMissingArgumentValue(tag);
                }
                if (arguments.get(tag) != null) {
                    PackageInfo.throwRepeatedArgument(tag);
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Value '" + args[nextArg] + "'", this);
                }
                if ((strValue = args[nextArg++]).startsWith(SERIAL_ARG_PREFIX)) {
                    actualValue = new ByteArrayInputStream(strValue.substring(SERIAL_ARG_PREFIX.length()).getBytes());
                } else if (strValue.startsWith(FILE_ARG_PREFIX)) {
                    String name = strValue.substring(FILE_ARG_PREFIX.length());
                    InputStreamWrapper wrapper = new InputStreamWrapper(name);
                    closer.register(wrapper);
                    if ("-".equals(name) && System.in.available() == 0) {
                        PackageInfo.throwStdinOverused();
                    }
                    actualValue = wrapper.getStream();
                } else {
                    actualValue = strValue;
                }
                arguments.put(tag, actualValue);
            }
            Context.getUISubsystem().execute(cmd, arguments, outputFormat, outputWrapper.getStream());
        }
        finally {
            closer.closeAll();
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Execution complete", this);
        }
    }

    public void execute(String cmdLine) throws Exception {
        String2StringArray c = new String2StringArray();
        c.setDelimiters(" ");
        this.execute(c.convert(cmdLine));
    }
}

