/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.clui;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.rolloutexpress.ui.BasicContext;
import com.raplix.rolloutexpress.ui.UIApplication;
import com.raplix.rolloutexpress.ui.clui.CLUISubsystem;
import com.raplix.rolloutexpress.ui.clui.PackageInfo;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.Replace;
import com.raplix.util.string.StringUtil;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Hashtable;

public class CLUI
extends UIApplication {
    private static final String ARG_COMMAND_SHORT = "-cmd";
    private static final String ARG_COMMAND_LONG = "-command";
    private static final String RESOLUTION_SEPARATOR = "|";
    private static final int CLUI_RETURNS_NOERROR = 0;
    private static final int CLUI_RETURNS_ERROR = 1;
    private CLUISubsystem mCLUISubsystem = new CLUISubsystem(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block21: {
            appArgs = args;
            cluiArgs = null;
            exitCode = 1;
            for (i = 0; i < args.length; ++i) {
                if (!"-cmd".equals(args[i]) && !"-command".equals(args[i])) continue;
                appArgs = (String[])CollectionUtil.sliceClass(args, String.class, CollectionUtil.FIRST_INDEX, i);
                cluiArgs = (String[])CollectionUtil.sliceClass(args, String.class, i + 1, CollectionUtil.LAST_INDEX);
                break;
            }
            clui = null;
            try {
                clui = CLUI.createInstance(appArgs);
                clui.getCLUISubsystem().execute(cluiArgs);
                exitCode = 0;
                var9_6 = null;
                ** if (clui == null) goto lbl-1000
            }
            catch (Throwable var8_16) {
                var9_8 = null;
                if (clui != null) {
                    try {
                        clui.shutdown();
                    }
                    catch (RaplixShutdownException e) {
                        exitCode = 1;
                    }
                }
                throw var8_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    clui.shutdown();
                }
                catch (RaplixShutdownException e) {
                    exitCode = 1;
                }
            }
lbl-1000:
            // 2 sources

            {
                break block21;
                catch (Throwable ex) {
                    message = null;
                    if (ex instanceof AccessControlException) {
                        p = ((AccessControlException)ex).getPermission();
                        if (p != null && p instanceof ROXPermission) {
                            message = ((ROXPermission)p).getMessage().toString();
                        }
                    } else if (ex instanceof ObjectInUseException) {
                        message = CLUI.getObjectInUseMessage((ObjectInUseException)ex);
                    }
                    if (message == null) {
                        message = ex.getMessage();
                    }
                    if (message == null) {
                        message = ex.toString();
                    } else {
                        index = message.indexOf("|");
                        if (index != -1) {
                            message = message.substring(0, index);
                        }
                        message = Replace.replace(message, '\n', StringUtil.LINE_SEPARATOR);
                    }
                    System.err.println(message);
                    if (Logger.isWarnEnabled(CLUI.class)) {
                        Logger.warn(message, ex, CLUI.class);
                    }
                    var9_7 = null;
                    if (clui != null) {
                        try {
                            clui.shutdown();
                        }
                        catch (RaplixShutdownException e) {
                            exitCode = 1;
                        }
                    }
                }
            }
        }
        System.exit(exitCode);
    }

    public CLUI(String[] args) throws ConfigurationException {
        super(args);
        RPCManager manager = this.getNetSubsystem().getRPC();
        try {
            this.mCLUISubsystem.registerRPCInterfaces(manager);
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ex.toString(), ex, this);
            }
            PackageInfo.throwRegistrationFailed(ex);
        }
        this.getNetSubsystem().postInit();
    }

    protected String getUsageString() {
        return super.getUsageString() + StringUtil.LINE_SEPARATOR + "   " + ARG_COMMAND_SHORT + " ...           command followed by its arguments";
    }

    protected String getVersionString() {
        return "5.2.1";
    }

    public CLUISubsystem getCLUISubsystem() {
        return this.mCLUISubsystem;
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable table) throws ConfigurationException {
        super.buildConfigurationFilesForSubsystems(table);
        Subsystem.addConfigurationForSubsystem(table, CLUISubsystem.class);
    }

    protected void shutdown() throws RaplixShutdownException {
        block2: {
            super.shutdown();
            try {
                this.mCLUISubsystem.prepareForShutdown();
                this.mCLUISubsystem.shutdown();
            }
            catch (RaplixShutdownException ex) {
                if (this.mShutdownRequestIsEmergency) break block2;
                throw ex;
            }
        }
    }

    public static CLUI createInstance(String[] args) throws ConfigurationException {
        CLUI clui = new CLUI(args);
        clui.start();
        PersistentServicesInit.setInitializer(new CLUIInitializer(clui.getNetSubsystem().getRPC()));
        return clui;
    }

    public String promptForInput(String[] inPrompts) throws IOException {
        return null;
    }

    private static String getObjectInUseMessage(ObjectInUseException ex) {
        UsingObject[] usingObjects = ex.getUsingObjects();
        String returnMessage = ex.getMessage();
        returnMessage = returnMessage + "\n[ ";
        for (int ndx = 0; ndx < usingObjects.length; ++ndx) {
            UsingObject blocker = usingObjects[ndx];
            returnMessage = returnMessage + " " + Util.getInUseMessage(blocker);
            if (ndx + 1 >= usingObjects.length) continue;
            returnMessage = returnMessage + ",";
        }
        returnMessage = returnMessage + " ]";
        return returnMessage;
    }

    private static class CLUIInitializer
    extends PersistentServicesInit.Initializer {
        public CLUIInitializer(RPCManager inRPC) {
            super(inRPC);
        }

        protected RPCInterface getServices() throws RPCException, PersistenceManagerException {
            try {
                return this.getPersistService(BasicContext.getServerAddress());
            }
            catch (IllegalStateException ise) {
                throw new PersistenceManagerException(new ROXMessage("pm.ERR_GET_MS_ADDRESS"), (Throwable)ise);
            }
        }
    }
}

