/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.catdb.formatters;

import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;

public final class CategoryUtil {
    private static final String ID_HEADER = "ui.cat.format.ID_HEADER";
    private static final String NAME_HEADER = "ui.cat.format.NAME_HEADER";
    private static final String DESCRIPTION_HEADER = "ui.cat.format.DESCRIPTION_HEADER";

    private CategoryUtil() {
    }

    public static void detailedWrite(PrintWriter pw, Category c, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(CategoryUtil.toText(ID_HEADER) + ": " + c.getID());
        pw.print(prefix);
        pw.println(CategoryUtil.toText(NAME_HEADER) + ": " + c.getName());
        pw.print(prefix);
        pw.println(CategoryUtil.toText(DESCRIPTION_HEADER) + ": " + c.getDescription());
    }

    public static void detailedWrite(PrintWriter pw, Category[] ca, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, CategoryUtil.toText(ID_HEADER)), new Column(15, 0, CategoryUtil.toText(NAME_HEADER)), new Column(20, 0, CategoryUtil.toText(DESCRIPTION_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[columns.length];
        for (int i = 0; i < ca.length; ++i) {
            data[0] = ca[i].getID().toString();
            data[1] = ca[i].getName();
            data[2] = ca[i].getDescription();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }
}

