/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.api;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.query.bean.RunningDiffBean;
import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaShorthand;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.executor.StepDescriptionContainer;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompWasRedundant;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.InvalidContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.node.bootstrap.VersionComparator;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.VariableSettingsSelector;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ComparisonType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVar;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionItem;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.ui.BasicContext;
import com.raplix.rolloutexpress.ui.CommandWrapper;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.PackageInfo;
import com.raplix.rolloutexpress.ui.UIApplication;
import com.raplix.rolloutexpress.ui.UISubsystem;
import com.raplix.rolloutexpress.ui.api.Messages;
import com.raplix.rolloutexpress.ui.converters.TimeInterval;
import com.raplix.rolloutexpress.ui.executor.converters.OutputType;
import com.raplix.rolloutexpress.ui.hostdbx.converters.UIAppInstanceUpdate;
import com.raplix.rolloutexpress.ui.net.converters.UITraceResult;
import com.raplix.util.collections.TypedSet;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import com.raplix.util.proxy.ProxyManager;
import com.sun.n1.sps.client.CommandManager;
import com.sun.n1.sps.client.CommandManagerBuilder;
import com.sun.n1.sps.client.ConversionException;
import com.sun.n1.sps.client.IllegalArgumentsException;
import com.sun.n1.sps.model.ObjectID;
import com.sun.n1.sps.model.PluginMember;
import com.sun.n1.sps.model.VersionNumber;
import com.sun.n1.sps.model.Visibility;
import com.sun.n1.sps.model.category.CategoryID;
import com.sun.n1.sps.model.component.CompCancelled;
import com.sun.n1.sps.model.component.CompCheckInID;
import com.sun.n1.sps.model.component.CompCheckInInfo;
import com.sun.n1.sps.model.component.CompComplete;
import com.sun.n1.sps.model.component.CompError;
import com.sun.n1.sps.model.component.Component;
import com.sun.n1.sps.model.component.ComponentIDSet;
import com.sun.n1.sps.model.component.ComponentTypeRefID;
import com.sun.n1.sps.model.component.ComponentTypeRefIDSet;
import com.sun.n1.sps.model.component.ComponentVariableSettings;
import com.sun.n1.sps.model.component.ComponentVariableSettingsID;
import com.sun.n1.sps.model.component.GeneratedVariableSettings;
import com.sun.n1.sps.model.component.GeneratedVariableSettingsID;
import com.sun.n1.sps.model.component.Modifier;
import com.sun.n1.sps.model.component.SummaryComponent;
import com.sun.n1.sps.model.component.SystemServiceRefID;
import com.sun.n1.sps.model.component.SystemServiceRefIDSet;
import com.sun.n1.sps.model.component.TargetRef;
import com.sun.n1.sps.model.component.VarDecl;
import com.sun.n1.sps.model.executor.RunLevel;
import com.sun.n1.sps.model.executor.RunningPlanBean;
import com.sun.n1.sps.model.executor.StepID;
import com.sun.n1.sps.model.executor.SubPlanPrompt;
import com.sun.n1.sps.model.executor.SubplanInfo;
import com.sun.n1.sps.model.executor.Target;
import com.sun.n1.sps.model.executor.TargetStatus;
import com.sun.n1.sps.model.folder.Folder;
import com.sun.n1.sps.model.folder.FolderAccessData;
import com.sun.n1.sps.model.folder.SummaryFolder;
import com.sun.n1.sps.model.host.AppType;
import com.sun.n1.sps.model.host.AttributeCriteria;
import com.sun.n1.sps.model.host.AttributeCriteriaList;
import com.sun.n1.sps.model.host.ConnectionType;
import com.sun.n1.sps.model.host.Host;
import com.sun.n1.sps.model.host.HostSearchCriteria;
import com.sun.n1.sps.model.host.HostSetID;
import com.sun.n1.sps.model.host.HostType;
import com.sun.n1.sps.model.host.HostTypeID;
import com.sun.n1.sps.model.host.HostTypeIDSet;
import com.sun.n1.sps.model.host.HostTypeVarList;
import com.sun.n1.sps.model.install.Dependency;
import com.sun.n1.sps.model.install.InstalledComponentBean;
import com.sun.n1.sps.model.install.InstalledComponentID;
import com.sun.n1.sps.model.install.InstalledComponentRef;
import com.sun.n1.sps.model.plan.ExecutionPlan;
import com.sun.n1.sps.model.plugin.BrowserInfo;
import com.sun.n1.sps.model.resource.RsrcInfo;
import com.sun.n1.sps.model.rule.CriteriaMetaData;
import com.sun.n1.sps.model.rule.HostStatus;
import com.sun.n1.sps.model.rule.RuleMetaData;
import com.sun.n1.sps.model.user.AuthenticationException;
import com.sun.n1.sps.model.user.Group;
import com.sun.n1.sps.model.user.GroupID;
import com.sun.n1.sps.model.user.PermissionID;
import com.sun.n1.sps.model.user.UserID;
import com.sun.n1.sps.model.util.ClientException;
import com.sun.n1.sps.model.util.NetworkException;
import com.sun.n1.sps.model.util.PingResult;
import com.sun.n1.sps.model.util.TraceFailed;
import com.sun.n1.sps.model.util.TraceResult;
import com.sun.n1.sps.model.util.TransformType;
import com.sun.n1.util.collections.TypedList;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class CommandManagerImpl
extends UIApplication
implements CommandManager,
Messages {
    private static final ThreadLocal sThreadLocalTable = new ThreadLocal();
    private static final ThreadLocal sThreadLocalThrowable = new ThreadLocal();
    private ProxyManager mProxyManager;
    private UISubsystem mUISubsystem;
    private boolean mIsTest = false;

    CommandManagerImpl(CommandManagerBuilder inCmdMgrBuilder) throws ConfigurationException {
        super(new String[0]);
        this.initPersistence();
        this.mProxyManager = new ProxyManager(inCmdMgrBuilder.getClassLoader());
        this.registerAll();
        this.mUISubsystem = new UISubsystem(this);
    }

    public CommandManagerImpl(Object inTest, String[] inArgs) throws ConfigurationException {
        super(inArgs);
        if (inTest.getClass().getName().indexOf(".test.") == -1) {
            throw new IllegalArgumentException("Should only be invoked from tests");
        }
        this.mIsTest = true;
        this.initPersistence();
        this.mProxyManager = new ProxyManager(ClassLoader.getSystemClassLoader());
        this.mUISubsystem = new UISubsystem(this);
    }

    public CommandManagerImpl(UISubsystem inUISubsystem) throws ConfigurationException {
        super(new String[0]);
        this.mProxyManager = new ProxyManager(this.getClass().getClassLoader());
        this.registerAll();
        this.mUISubsystem = inUISubsystem;
    }

    CommandManagerImpl(String[] args, CommandManagerBuilder inCmdMgrBuilder) throws ConfigurationException {
        super(args);
        this.initPersistence();
        this.mProxyManager = new ProxyManager(inCmdMgrBuilder.getClassLoader());
        this.registerAll();
        this.mUISubsystem = new UISubsystem(this);
    }

    private void initPersistence() {
        PersistentServicesInit.setInitializer(new CmdMgrRPCInitializer(this.getNetSubsystem().getRPC()));
    }

    public ProxyManager getProxyManager() {
        return this.mProxyManager;
    }

    public Object execute(String inCmdName, Map inArgMap) throws ClientException {
        try {
            return this.innerExecute(inCmdName, inArgMap);
        }
        catch (Throwable t) {
            throw ClientException.wrap(t);
        }
    }

    private Hashtable createPrivateParamHash(Map inPublicArgMap) throws ConversionException, IllegalArgumentsException {
        Hashtable<String, Object> theHash = new Hashtable<String, Object>();
        if (inPublicArgMap != null) {
            Iterator theIter = inPublicArgMap.entrySet().iterator();
            while (theIter.hasNext()) {
                Map.Entry theEntry = theIter.next();
                Object theKey = theEntry.getKey();
                if (!(theKey instanceof String)) {
                    throw new IllegalArgumentsException(MessageManager.messageAsString("ui.api.ONLY_STRING_SWITCHES", new Object[]{theKey.getClass().getName()}));
                }
                String theKeyString = (String)theKey;
                while (theKeyString.startsWith("-")) {
                    theKeyString = theKeyString.substring(1);
                }
                Object theValueIface = theEntry.getValue();
                Object theValueImpl = this.mProxyManager.publicToPrivateInstance(theValueIface);
                if (theValueImpl == null) {
                    throw new ConversionException(MessageManager.messageAsString("ui.api.NO_VALUE_FOR_KEY", new Object[]{theKey, theValueIface}), null);
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("InnerExec just put key <" + theKey + "> value <" + theValueImpl + ">", this);
                }
                theHash.put(theKeyString, theValueImpl);
            }
        }
        return theHash;
    }

    private Object innerExecute(String inCmdName, Map inArgMap) throws ClientException {
        Object theResultIface;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Entering innerExecute for command " + inCmdName, this);
        }
        Hashtable theHash = this.createPrivateParamHash(inArgMap);
        CommandWrapper theCmdWrapper = this.mUISubsystem.getCommandWrapper(inCmdName);
        Object theResult = null;
        try {
            this.setExecuteException(null);
            try {
                theResult = this.mUISubsystem.execute(theCmdWrapper.getCommand(), theHash, CommandManagerImpl.getDefaultOutputStream());
            }
            catch (Throwable t) {
                this.setExecuteException(t);
                throw t;
            }
        }
        catch (IllegalStateException e) {
            Logger.debug("IllegalStateException while executing command " + inCmdName, e, this);
            if (e.getMessage().indexOf("(029005)") != -1) {
                throw new AuthenticationException(MessageManager.messageAsString("ui.api.CMD_AUTH_ERR", new Object[]{inCmdName}), e);
            }
            throw new ClientException(MessageManager.messageAsString("ui.api.UNEXPECTED_ILLEGAL_STATE"), e);
        }
        catch (InvalidContext e) {
            Logger.debug("Invalid context error while executing command " + inCmdName, e, this);
            throw new AuthenticationException(MessageManager.messageAsString("ui.api.INVALID_CMD_CTX", new Object[]{inCmdName}), e);
        }
        catch (com.raplix.rolloutexpress.systemmodel.userdb.AuthenticationException e) {
            Logger.debug("Authentication error while executing command " + inCmdName, e, this);
            throw new AuthenticationException(MessageManager.messageAsString("ui.api.CMD_AUTH_ERR_2", new Object[]{inCmdName}), e);
        }
        catch (IllegalArgumentException e) {
            Logger.debug("Illegal argument to command " + inCmdName, e, this);
            throw new IllegalArgumentsException(MessageManager.messageAsString("ui.api.ILLEGAL_CMD_ARG", new Object[]{inCmdName}), e);
        }
        catch (Throwable t) {
            Logger.debug("Error while executing command " + inCmdName, t, this);
            throw ClientException.wrap(t);
        }
        try {
            theResultIface = this.mProxyManager.privateToPublicInstance(theResult);
        }
        catch (ConversionException ce) {
            throw ClientException.wrap(ce);
        }
        catch (Exception t) {
            throw ClientException.wrap(t);
        }
        if (!this.mIsTest && theResultIface != null && theResultIface.getClass().getName().startsWith("com.raplix.")) {
            throw new ClientException(MessageManager.messageAsString("ui.api.PRIVATE_OBJ_RETURNED", new Object[]{theResultIface.getClass().getName()}), null);
        }
        return theResultIface;
    }

    public Object convert(String inConvString, Class inTargetClass) throws ClientException {
        try {
            return this.innerConvert(inConvString, inTargetClass);
        }
        catch (Throwable t) {
            throw ClientException.wrap(t);
        }
    }

    private Object innerConvert(String inConvString, Class inTargetClass) throws ClientException {
        try {
            Class theImplClass = this.mProxyManager.publicToPrivateClass(inTargetClass);
            Object theResultImpl = this.mUISubsystem.getConverterHandler().convert(inConvString, theImplClass);
            return this.mProxyManager.privateToPublicInstance(theResultImpl);
        }
        catch (Throwable t) {
            throw ClientException.wrap(t);
        }
    }

    public void close() {
        this.requestShutdown();
    }

    public String getVersionString() {
        return CommandManagerBuilder.getVersion();
    }

    private Object defaultConstruct(Class inClass) throws ClientException {
        Constructor<?>[] theConstructorArray = inClass.getDeclaredConstructors();
        for (int i = 0; i < theConstructorArray.length; ++i) {
            if (theConstructorArray[i].getParameterTypes().length != 0) continue;
            try {
                Constructor<?> theDefaultConstructor = theConstructorArray[i];
                theDefaultConstructor.setAccessible(true);
                return theDefaultConstructor.newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw new ClientException(MessageManager.messageAsString("ui.api.NO_DEFAULT_CONSTRUCTOR", new Object[]{inClass.getName()}), t);
            }
        }
        throw new ClientException(MessageManager.messageAsString("ui.api.NO_DEFAULT_CONSTRUCTOR", new Object[]{inClass.getName()}), null);
    }

    public com.sun.n1.util.collections.TypedSet createEmptySet(Class inPublicIfaceClass) throws ClientException {
        if (!com.sun.n1.util.collections.TypedSet.class.isAssignableFrom(inPublicIfaceClass)) {
            throw new IllegalArgumentsException(MessageManager.messageAsString("ui.api.NOT_TYPEDSET_DESCENDANT", new Object[]{inPublicIfaceClass.getName()}), null);
        }
        try {
            Class theImplClass = this.mProxyManager.publicToPrivateClass(inPublicIfaceClass);
            Object theInstance = this.defaultConstruct(theImplClass);
            return (com.sun.n1.util.collections.TypedSet)this.mProxyManager.privateToPublicInstance(theInstance);
        }
        catch (Throwable t) {
            throw ClientException.wrap(t);
        }
    }

    public TypedList createEmptyList(Class inPublicIfaceClass) throws ClientException {
        if (!TypedList.class.isAssignableFrom(inPublicIfaceClass)) {
            throw new IllegalArgumentsException(MessageManager.messageAsString("ui.api.NOT_TYPEDLIST_DESCENDANT", new Object[]{inPublicIfaceClass.getName()}), null);
        }
        try {
            Class theImplClass = this.mProxyManager.publicToPrivateClass(inPublicIfaceClass);
            Object theInstance = this.defaultConstruct(theImplClass);
            return (TypedList)this.mProxyManager.privateToPublicInstance(theInstance);
        }
        catch (Throwable t) {
            throw ClientException.wrap(t);
        }
    }

    public com.sun.n1.sps.model.user.SessionID getSessionID() throws ClientException {
        SessionID internal = null;
        try {
            internal = Context.getUIContextServices().getSessionID();
            return (com.sun.n1.sps.model.user.SessionID)this.mProxyManager.privateToPublicInstance(internal);
        }
        catch (Throwable t) {
            throw ClientException.wrap(t);
        }
    }

    public void setSessionID(com.sun.n1.sps.model.user.SessionID inSessionID) throws ClientException {
        try {
            SessionID internal = (SessionID)this.mProxyManager.publicToPrivateInstance(inSessionID);
            Context.getUIContextServices().setSessionID(internal);
        }
        catch (Throwable t) {
            throw ClientException.wrap(t);
        }
    }

    public void clearSession() throws ClientException {
        try {
            Context.getUIContextServices().setSessionID(null);
        }
        catch (Throwable t) {
            throw new ClientException(MessageManager.messageAsString("ui.api.UNEXPECTED_SET_SESSION_ERR"), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalOutputStream(OutputStream inOutputStream) {
        ThreadLocal threadLocal = sThreadLocalTable;
        synchronized (threadLocal) {
            sThreadLocalTable.set(inOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream getDefaultOutputStream() {
        ThreadLocal threadLocal = sThreadLocalTable;
        synchronized (threadLocal) {
            OutputStream theOutStream = (OutputStream)sThreadLocalTable.get();
            if (theOutStream == null) {
                theOutStream = new OutputStream(){

                    public void write(int i) {
                    }

                    public void write(byte[] b) {
                    }

                    public void write(byte[] b, int off, int len) {
                    }
                };
                sThreadLocalTable.set(theOutStream);
            }
            return theOutStream;
        }
    }

    private static String getCluiVersion() {
        return "5.2.1";
    }

    private static String getBuildNumber() {
        return "20060419020000";
    }

    private static Boolean checkVersion(String publicAPIVersion) {
        VersionComparator vc = VersionComparator.INSTANCE;
        if (vc.compareVersion(publicAPIVersion, "5.2.1") <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void pingServer() throws NetworkException {
        com.raplix.rolloutexpress.net.transport.PingResult pr = null;
        try {
            pr = this.getNetSubsystem().getTransport().getControl().ping(BasicContext.getServerAddress());
        }
        catch (Exception e) {
            PackageInfo.throwServerNotFound(e);
        }
        if (!pr.isSuccess()) {
            throw new NetworkException(Context.getMessageText("ui.EX_SERVER_NOT_FOUND_UNKNOWN"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecuteException(Throwable t) {
        ThreadLocal threadLocal = sThreadLocalThrowable;
        synchronized (threadLocal) {
            sThreadLocalThrowable.set(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getExecuteException() {
        ThreadLocal threadLocal = sThreadLocalThrowable;
        synchronized (threadLocal) {
            return (Throwable)sThreadLocalThrowable.get();
        }
    }

    protected void registerAll() {
        this.registerClass(ObjectID.class, com.raplix.rolloutexpress.persist.ObjectID.class);
        this.registerClass(PluginMember.class, com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember.class);
        this.registerClass(com.sun.n1.util.collections.TypedSet.class, TypedSet.class);
        this.registerClass(VersionNumber.class, com.raplix.rolloutexpress.persist.VersionNumber.class);
        this.registerClass(Visibility.class, com.raplix.rolloutexpress.persist.Visibility.class);
        this.registerClass(com.sun.n1.sps.model.category.Category.class, Category.class);
        this.registerClass(CategoryID.class, com.raplix.rolloutexpress.systemmodel.catdb.CategoryID.class);
        this.registerClass(com.sun.n1.sps.model.category.CategoryIDSet.class, CategoryIDSet.class);
        this.registerClass(CompCheckInID.class, com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID.class);
        this.registerClass(CompCheckInInfo.class, com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInInfo.class);
        this.registerClass(Component.class, com.raplix.rolloutexpress.systemmodel.componentdb.Component.class);
        this.registerClass(com.sun.n1.sps.model.component.ComponentID.class, ComponentID.class);
        this.registerClass(ComponentIDSet.class, com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet.class);
        this.registerClass(com.sun.n1.sps.model.component.ComponentTypeRef.class, ComponentTypeRef.class);
        this.registerClass(ComponentTypeRefID.class, com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID.class);
        this.registerClass(ComponentTypeRefIDSet.class, com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefIDSet.class);
        this.registerClass(ComponentVariableSettings.class, com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings.class);
        this.registerClass(ComponentVariableSettingsID.class, com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsID.class);
        this.registerClass(com.sun.n1.sps.model.component.ComponentSelector.class, ComponentSelector.class);
        this.registerClass(com.sun.n1.sps.model.component.VariableSettingsSelector.class, VariableSettingsSelector.class);
        this.registerClass(com.sun.n1.sps.model.component.CompStatus.class, CompStatus.class);
        this.registerClass(GeneratedVariableSettings.class, com.raplix.rolloutexpress.config.GeneratedVariableSettings.class);
        this.registerClass(GeneratedVariableSettingsID.class, com.raplix.rolloutexpress.config.GeneratedVariableSettingsID.class);
        this.registerClass(com.sun.n1.sps.model.component.NamedBlockType.class, NamedBlockType.class);
        this.registerClass(SummaryComponent.class, com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent.class);
        this.registerClass(com.sun.n1.sps.model.component.SystemServiceRef.class, SystemServiceRef.class);
        this.registerClass(SystemServiceRefID.class, com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID.class);
        this.registerClass(SystemServiceRefIDSet.class, com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefIDSet.class);
        this.registerClass(TargetRef.class, com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef.class);
        this.registerClass(CompCancelled.class, com.raplix.rolloutexpress.hierarchies.compexport.status.CompCancelled.class);
        this.registerClass(CompComplete.class, com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete.class);
        this.registerClass(CompError.class, com.raplix.rolloutexpress.hierarchies.compexport.status.CompError.class);
        this.registerClass(com.sun.n1.sps.model.component.CompPending.class, CompPending.class);
        this.registerClass(com.sun.n1.sps.model.component.CompWasRedundant.class, CompWasRedundant.class);
        this.registerClass(com.sun.n1.sps.model.component.ComponentRef.class, ComponentRef.class);
        this.registerClass(Modifier.class, com.raplix.rolloutexpress.systemmodel.componentdb.Modifier.class);
        this.registerClass(VarDecl.class, com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl.class);
        this.registerClass(com.sun.n1.sps.model.difference.DifferenceJobID.class, DifferenceJobID.class);
        this.registerClass(com.sun.n1.sps.model.difference.DifferenceSettings.class, DifferenceSettings.class);
        this.registerClass(com.sun.n1.sps.model.difference.DifferenceSettingsID.class, DifferenceSettingsID.class);
        this.registerClass(com.sun.n1.sps.model.difference.RunningDiffBean.class, RunningDiffBean.class);
        this.registerClass(com.sun.n1.sps.model.executor.OutputType.class, OutputType.class);
        this.registerClass(RunningPlanBean.class, com.raplix.rolloutexpress.event.query.bean.RunningPlanBean.class);
        this.registerClass(StepID.class, com.raplix.rolloutexpress.executor.StepID.class);
        this.registerClass(SubPlanPrompt.class, SubplanPrompt.class);
        this.registerClass(com.sun.n1.sps.model.executor.TaskID.class, TaskID.class);
        this.registerClass(com.sun.n1.sps.model.executor.TaskInfo.class, TaskInfo.class);
        this.registerClass(RunLevel.class, com.raplix.rolloutexpress.executor.RunLevel.class);
        this.registerClass(SubplanInfo.class, com.raplix.rolloutexpress.executor.SubplanInfo.class);
        this.registerClass(Target.class, com.raplix.rolloutexpress.executor.target.Target.class);
        this.registerClass(TargetStatus.class, com.raplix.rolloutexpress.event.TargetStatus.class);
        this.registerClass(com.sun.n1.sps.model.executor.TaskStatus.class, TaskStatus.class);
        this.registerClass(com.sun.n1.sps.model.executor.ExecNativeOutput.class, ExecNativeOutput.class);
        this.registerClass(com.sun.n1.sps.model.executor.StepDescriptionContainer.class, StepDescriptionContainer.class);
        this.registerClass(Folder.class, com.raplix.rolloutexpress.systemmodel.folderdb.Folder.class);
        this.registerClass(SummaryFolder.class, com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder.class);
        this.registerClass(com.sun.n1.sps.model.folder.FolderID.class, FolderID.class);
        this.registerClass(com.sun.n1.sps.model.folder.FolderIDSet.class, FolderIDSet.class);
        this.registerClass(com.sun.n1.sps.model.host.AppInstance.class, AppInstance.class);
        this.registerClass(com.sun.n1.sps.model.host.AppInstanceID.class, AppInstanceID.class);
        this.registerClass(com.sun.n1.sps.model.host.AppTypeCriteria.class, AppTypeCriteria.class);
        this.registerClass(AppType.class, com.raplix.rolloutexpress.systemmodel.hostdbx.AppType.class);
        this.registerClass(AttributeCriteria.class, com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria.class);
        this.registerClass(AttributeCriteriaList.class, com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaList.class);
        this.registerClass(ConnectionType.class, com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType.class);
        this.registerClass(com.sun.n1.sps.model.host.ComparisonType.class, ComparisonType.class);
        this.registerClass(Host.class, com.raplix.rolloutexpress.systemmodel.hostdbx.Host.class);
        this.registerClass(com.sun.n1.sps.model.host.HostID.class, HostID.class);
        this.registerClass(com.sun.n1.sps.model.host.HostIDSet.class, HostIDSet.class);
        this.registerClass(com.sun.n1.sps.model.host.HostSearch.class, HostSearch.class);
        this.registerClass(HostSearchCriteria.class, com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria.class);
        this.registerClass(com.sun.n1.sps.model.host.HostSearchID.class, HostSearchID.class);
        this.registerClass(com.sun.n1.sps.model.host.HostSearchIDSet.class, HostSearchIDSet.class);
        this.registerClass(com.sun.n1.sps.model.host.HostSet.class, HostSet.class);
        this.registerClass(HostSetID.class, com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID.class);
        this.registerClass(com.sun.n1.sps.model.host.HostSetIDSet.class, HostSetIDSet.class);
        this.registerClass(HostType.class, com.raplix.rolloutexpress.systemmodel.hostdbx.HostType.class);
        this.registerClass(HostTypeID.class, com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID.class);
        this.registerClass(HostTypeIDSet.class, com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet.class);
        this.registerClass(com.sun.n1.sps.model.host.HostTypeVar.class, HostTypeVar.class);
        this.registerClass(HostTypeVarList.class, com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVarList.class);
        this.registerClass(com.sun.n1.sps.model.host.MachineInfo.class, MachineInfo.class);
        this.registerClass(com.sun.n1.sps.model.host.PhysicalCriteria.class, PhysicalCriteria.class);
        this.registerClass(com.sun.n1.sps.model.host.UIAppInstanceUpdate.class, UIAppInstanceUpdate.class);
        this.registerClass(com.sun.n1.sps.model.install.InstalledComponent.class, InstalledComponent.class);
        this.registerClass(InstalledComponentBean.class, com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean.class);
        this.registerClass(InstalledComponentID.class, com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID.class);
        this.registerClass(InstalledComponentRef.class, com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef.class);
        this.registerClass(Dependency.class, com.raplix.rolloutexpress.systemmodel.installdb.Dependency.class);
        this.registerClass(ExecutionPlan.class, com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan.class);
        this.registerClass(com.sun.n1.sps.model.plan.ExecutionPlanID.class, ExecutionPlanID.class);
        this.registerClass(com.sun.n1.sps.model.plan.ExecutionPlanIDSet.class, ExecutionPlanIDSet.class);
        this.registerClass(com.sun.n1.sps.model.plan.ExecutionMode.class, ExecutionMode.class);
        this.registerClass(BrowserInfo.class, com.sun.n1.sps.plugin.browse.BrowserInfo.class);
        this.registerClass(com.sun.n1.sps.model.plugin.Plugin.class, Plugin.class);
        this.registerClass(com.sun.n1.sps.model.plugin.PluginID.class, PluginID.class);
        this.registerClass(com.sun.n1.sps.model.plugin.PluginIDSet.class, PluginIDSet.class);
        this.registerClass(com.sun.n1.sps.model.rule.CriteriaShorthand.class, CriteriaShorthand.class);
        this.registerClass(RuleMetaData.class, com.raplix.rolloutexpress.event.rule.RuleMetaData.class);
        this.registerClass(com.sun.n1.sps.model.rule.ActionMetaData.class, ActionMetaData.class);
        this.registerClass(CriteriaMetaData.class, com.raplix.rolloutexpress.event.rule.CriteriaMetaData.class);
        this.registerClass(com.sun.n1.sps.model.rule.RuleID.class, RuleID.class);
        this.registerClass(HostStatus.class, com.raplix.rolloutexpress.event.HostStatus.class);
        this.registerClass(Group.class, com.raplix.rolloutexpress.systemmodel.userdb.Group.class);
        this.registerClass(GroupID.class, com.raplix.rolloutexpress.systemmodel.userdb.GroupID.class);
        this.registerClass(com.sun.n1.sps.model.user.LoginConfiguration.class, LoginConfiguration.class);
        this.registerClass(com.sun.n1.sps.model.user.Permission.class, Permission.class);
        this.registerClass(PermissionID.class, com.raplix.rolloutexpress.systemmodel.userdb.PermissionID.class);
        this.registerClass(com.sun.n1.sps.model.user.SessionID.class, SessionID.class);
        this.registerClass(com.sun.n1.sps.model.user.SessionVariable.class, SessionVariable.class);
        this.registerClass(com.sun.n1.sps.model.user.SessionVariableSet.class, SessionVariableSet.class);
        this.registerClass(com.sun.n1.sps.model.user.User.class, User.class);
        this.registerClass(UserID.class, com.raplix.rolloutexpress.systemmodel.userdb.UserID.class);
        this.registerClass(FolderAccessData.class, com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData.class);
        this.registerClass(com.sun.n1.sps.model.folder.FolderPermissionItem.class, FolderPermissionItem.class);
        this.registerClass(com.sun.n1.sps.model.user.GroupIDSet.class, GroupIDSet.class);
        this.registerClass(RsrcInfo.class, com.raplix.rolloutexpress.resource.RsrcInfo.class);
        this.registerClass(PingResult.class, com.raplix.rolloutexpress.net.transport.PingResult.class);
        this.registerClass(com.sun.n1.sps.model.util.RoxAddress.class, RoxAddress.class);
        this.registerClass(com.sun.n1.sps.model.util.TimeInterval.class, TimeInterval.class);
        this.registerClass(TraceResult.class, com.raplix.rolloutexpress.net.transport.TraceResult.class);
        this.registerClass(TransformType.class, com.raplix.rolloutexpress.systemmodel.plandb.TransformType.class);
        this.registerClass(com.sun.n1.sps.model.util.UITraceResult.class, UITraceResult.class);
        this.registerClass(com.sun.n1.sps.model.util.PromptParamList.class, PromptParamList.class);
        this.registerClass(TraceFailed.class, com.raplix.rolloutexpress.net.transport.TraceFailed.class);
    }

    public void registerClass(Class inInterfaceClass, Class inImplClass) {
        this.mProxyManager.register(inInterfaceClass, inImplClass);
    }

    public void forTestOnly_clearRegistrations() {
        if (!this.mIsTest) {
            throw new IllegalStateException("This method should only be used for tests");
        }
        this.mProxyManager = new ProxyManager(this.mProxyManager.getLoader());
    }

    private static class CmdMgrRPCInitializer
    extends PersistentServicesInit.Initializer {
        public CmdMgrRPCInitializer(RPCManager inRPC) {
            super(inRPC);
        }

        protected RPCInterface getServices() throws RPCException, PersistenceManagerException {
            try {
                return this.getPersistService(BasicContext.getServerAddress());
            }
            catch (IllegalStateException ise) {
                throw new PersistenceManagerException(new ROXMessage("pm.ERR_GET_MS_ADDRESS"), (Throwable)ise);
            }
        }
    }
}

