/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui;

import [Ljava.lang.String;;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.ui.ArgumentDescriptor;
import com.raplix.rolloutexpress.ui.Authorizer;
import com.raplix.rolloutexpress.ui.Command;
import com.raplix.rolloutexpress.ui.CommandWrapper;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterHandler;
import com.raplix.rolloutexpress.ui.ExecutorHandler;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.PackageInfo;
import com.raplix.rolloutexpress.ui.ResultDescriptor;
import com.raplix.rolloutexpress.ui.Serializer;
import com.raplix.rolloutexpress.ui.UIApplication;
import com.raplix.rolloutexpress.ui.commands.CommandRepository;
import com.raplix.rolloutexpress.ui.commands.ListAuthorizer;
import com.raplix.rolloutexpress.ui.serializers.JRESerializer;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.reflect.ClassUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class UISubsystem
extends Subsystem {
    private static final String ELEM_ROOT = "clui-config";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_SERIALIZER = "serializer";
    private static final String ATTR_DATE_FORMAT = "dateFormat";
    private static final String CFG_FILE_VERSION = "1.0";
    private static final String CFG_PREFIX = "ui.";
    private static final String CFG_VAR_FILE = "configFile";
    private static final String CFG_VAR_FILE_VALUE = "ui_config.xml";
    private Authorizer mAuthorizer;
    private Serializer mSerializer;
    private CommandRepository mRepository;
    private ConverterHandler mHandler;

    public UISubsystem(UIApplication app) throws ConfigurationException {
        super(app);
        Node serializer;
        Context.setApp(app);
        String name = this.getConfigurationAsString(CFG_VAR_FILE);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            PackageInfo.throwConfigNotFound(name);
        }
        Node node = XMLUtil.parse(new InputSource(stream)).getFirstChild();
        String version = node.getAttributes().getNamedItem(ATTR_VERSION).getNodeValue();
        if (!CFG_FILE_VERSION.equals(version)) {
            PackageInfo.throwVersionMismatch(CFG_FILE_VERSION, version);
        }
        this.mSerializer = (serializer = node.getAttributes().getNamedItem(ATTR_SERIALIZER)) == null ? new JRESerializer() : (Serializer)ClassUtil.createObject(serializer.getNodeValue(), Serializer.class);
        String date = null;
        Node dateNode = node.getAttributes().getNamedItem(ATTR_DATE_FORMAT);
        if (dateNode != null) {
            date = dateNode.getNodeValue();
        }
        this.mHandler = new ExecutorHandler(date);
        DOMElementEnumeration e = new DOMElementEnumeration(node);
        this.mRepository = new CommandRepository(e.nextElement());
        this.mAuthorizer = new ListAuthorizer(e.nextElement());
    }

    public UISubsystem() {
        this.mHandler = new ExecutorHandler(null);
        this.mSerializer = new JRESerializer();
        this.mRepository = new CommandRepository();
        this.mAuthorizer = new ListAuthorizer();
    }

    protected String getConfigurationPropertyPrefix() {
        return CFG_PREFIX;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        if (this.mApplication == null) {
            return null;
        }
        return new DefaultConfiguration[]{new DefaultConfiguration(CFG_VAR_FILE, this.mApplication.getDataDirAbsPath() + File.separator + CFG_VAR_FILE_VALUE, "Configuration file")};
    }

    public Authorizer getAuthorizer() {
        return this.mAuthorizer;
    }

    public Serializer getSerializer() {
        return this.mSerializer;
    }

    public ConverterHandler getConverterHandler() {
        return this.mHandler;
    }

    public String[] getWrapperNames(String pattern) {
        String[] matchingNames = this.mRepository.getMatchingNames(pattern);
        Vector<String> authorizedNames = new Vector<String>();
        for (int i = 0; i < matchingNames.length; ++i) {
            try {
                this.getCommandWrapper(matchingNames[i]);
                authorizedNames.addElement(matchingNames[i]);
                continue;
            }
            catch (AccessControlException ex) {
                // empty catch block
            }
        }
        return (String[])CollectionUtil.mapClass(authorizedNames, String;.class);
    }

    public CommandWrapper getCommandWrapper(String name) {
        CommandWrapper w = this.mRepository.getCommandWrapper(name);
        this.getAuthorizer().authorize(w);
        return w;
    }

    public void setArguments(Command command, Hashtable arguments) throws Exception {
        ArgumentDescriptor[] aDesc = command.getHelp().getArgumentDescriptors();
        Hashtable args = (Hashtable)arguments.clone();
        if (aDesc != null) {
            for (int i = 0; i < aDesc.length; ++i) {
                String tag = aDesc[i].getTag();
                Object value = args.remove(tag);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Setting '" + tag + "' from '" + value + "'", this);
                }
                if (value == null) {
                    if (aDesc[i].getOptional() != 0) continue;
                    PackageInfo.throwArgumentRequired(tag);
                    continue;
                }
                if (value instanceof InputStream) {
                    value = this.getSerializer().read((InputStream)value);
                }
                aDesc[i].set(command, this.getConverterHandler().convert(value, aDesc[i].getType()));
            }
        }
        if (args.size() != 0) {
            StringBuffer buffer = new StringBuffer();
            Enumeration e = args.keys();
            while (e.hasMoreElements()) {
                buffer.append(e.nextElement());
                if (!e.hasMoreElements()) continue;
                buffer.append(' ');
            }
            PackageInfo.throwArgumentUnknown(buffer.toString());
        }
    }

    public Object execute(Command command, Hashtable arguments) throws Exception {
        return this.execute(command, arguments, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Command command, Hashtable arguments, OutputStream inDefaultOutputStream) throws Exception {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing '" + command + "'", this);
        }
        try {
            this.setArguments(command, arguments);
            if (inDefaultOutputStream != null && command instanceof OutputCommand) {
                ((OutputCommand)command).setOutputStream(inDefaultOutputStream);
            }
            command.authorize();
            command.execute();
        }
        finally {
            command.cleanup();
        }
        ResultDescriptor desc = command.getHelp().getResultDescriptor();
        if (desc == null) {
            return null;
        }
        return desc.get(command);
    }

    public Object execute(String name, Hashtable arguments) throws Exception {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing '" + name + "'", this);
        }
        return this.execute(this.getCommandWrapper(name).getCommand(), arguments);
    }

    public Object execute(String name, Hashtable arguments, Class cls) throws Exception {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing '" + name + "'", this);
        }
        return this.getConverterHandler().convert(this.execute(name, arguments), cls);
    }

    public void execute(CommandWrapper wrapper, Hashtable arguments, String outputFormat, OutputStream out) throws Exception {
        Command cmd;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing '" + wrapper.getName() + "'", this);
        }
        if ((cmd = wrapper.getCommand()) instanceof OutputCommand) {
            ((OutputCommand)cmd).setOutputStream(out);
        }
        wrapper.getFormatter(outputFormat).write(this.execute(cmd, arguments), out);
    }

    public void execute(String name, Hashtable arguments, String outputFormat, OutputStream out) throws Exception {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing '" + name + "'", this);
        }
        this.execute(this.getCommandWrapper(name), arguments, outputFormat, out);
    }

    public void execute(String name, Hashtable arguments, OutputStream out) throws Exception {
        this.execute(this.getCommandWrapper(name), arguments, null, out);
    }
}

