/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBSubsystem;
import com.raplix.rolloutexpress.ui.PackageInfo;
import com.raplix.rolloutexpress.ui.UIContextServices;
import com.raplix.rolloutexpress.ui.UISubsystem;
import com.raplix.rolloutexpress.ui.clui.CLUISubsystem;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;

public abstract class UIApplication
extends Application {
    private static final String ERROR_NO_CLUI_SUBSYSTEM = "This application does not have a Command-Line UI Subsystem.";
    private NetSubsystem mNet = NetSubsystem.createNetSubsystemForClient(this);
    private UISubsystem mUISubsystem;
    private RemoteUserDBSubsystem mUserDBSubsystem = new RemoteUserDBSubsystem(this);
    private UIContextServices mUIContextServices;

    public UIApplication(String[] args) throws ConfigurationException {
        super(args);
        this.mUISubsystem = new UISubsystem(this);
        RPCManager manager = this.mNet.getRPC();
        this.mUIContextServices = new UIContextServices();
        try {
            manager.getContextManager().activateServices(this.mUIContextServices);
        }
        catch (ContextException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ex.toString(), ex, this);
            }
            PackageInfo.throwInvalidContext(ex);
        }
        try {
            this.mNet.registerRPCInterfaces(manager);
            this.mUserDBSubsystem.registerRPCInterfaces(manager);
            this.mUISubsystem.registerRPCInterfaces(manager);
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ex.toString(), ex, this);
            }
            PackageInfo.throwRegistrationFailed(ex);
        }
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNet;
    }

    public RemoteUserDBSubsystem getRemoteUserDBSubsystem() {
        return this.mUserDBSubsystem;
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable table) throws ConfigurationException {
        Subsystem.addConfigurationForSubsystem(table, NetSubsystem.class);
        Subsystem.addConfigurationForSubsystem(table, RemoteUserDBSubsystem.class);
        Subsystem.addConfigurationForSubsystem(table, UISubsystem.class);
    }

    protected void shutdown() throws RaplixShutdownException {
        block2: {
            try {
                this.mNet.prepareForShutdown();
                this.mUserDBSubsystem.prepareForShutdown();
                this.mUISubsystem.prepareForShutdown();
                this.mNet.shutdown();
                this.mUserDBSubsystem.shutdown();
                this.mUISubsystem.shutdown();
            }
            catch (RaplixShutdownException ex) {
                if (this.mShutdownRequestIsEmergency) break block2;
                throw ex;
            }
        }
    }

    public UIContextServices getUIContextServices() {
        return this.mUIContextServices;
    }

    public UISubsystem getUISubsystem() {
        return this.mUISubsystem;
    }

    public CLUISubsystem getCLUISubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_CLUI_SUBSYSTEM);
    }
}

