/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.util.logger.Logger;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "ui";
    public static final String EX_ARGUMENT_REQUIRED = "ui.EX_ARGUMENT_REQUIRED";
    public static final String EX_ARGUMENT_UNKNOWN = "ui.EX_ARGUMENT_UNKNOWN";
    public static final String EX_VERSION_MISMATCH = "ui.EX_VERSION_MISMATCH";
    public static final String EX_SERVER_NOT_FOUND_UNKNOWN = "ui.EX_SERVER_NOT_FOUND_UNKNOWN";
    public static final String EX_SERVER_NOT_FOUND = "ui.EX_SERVER_NOT_FOUND";
    public static final String EX_INTERFACE_UNAVAILABLE = "ui.EX_INTERFACE_UNAVAILABLE";
    public static final String EX_UNSUPPORTED_SUBSYSTEM = "ui.EX_UNSUPPORTED_SUBSYSTEM";
    public static final String EX_REGISTRATION_FAILED = "ui.EX_REGISTRATION_FAILED";
    public static final String EX_INVALID_CONTEXT = "ui.EX_INVALID_CONTEXT";
    public static final String EX_CONFIG_NOT_FOUND = "ui.EX_CONFIG_NOT_FOUND";

    private PackageInfo() {
    }

    public static void throwArgumentRequired(String tag) {
        throw new IllegalArgumentException(Context.getMessageText(EX_ARGUMENT_REQUIRED, tag));
    }

    public static void throwArgumentUnknown(String tag) {
        throw new IllegalArgumentException(Context.getMessageText(EX_ARGUMENT_UNKNOWN, tag));
    }

    public static void throwVersionMismatch(String expected, String actual) throws ConfigurationException {
        throw new ConfigurationException(EX_VERSION_MISMATCH, new Object[]{expected, actual});
    }

    public static void throwServerNotFound() {
        throw new IllegalStateException(Context.getMessageText(EX_SERVER_NOT_FOUND_UNKNOWN));
    }

    public static void throwServerNotFound(Exception ex) {
        String message = Context.getMessageText(EX_SERVER_NOT_FOUND, ex.getMessage());
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        throw new IllegalStateException(message);
    }

    public static void throwInterfaceUnavailable(Class cls, Exception ex) {
        String message = Context.getMessageText(EX_INTERFACE_UNAVAILABLE, cls.getName(), ex.getMessage());
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        throw new IllegalStateException(message);
    }

    public static void throwUnsupportedSubsystem(Class cls, Exception ex) {
        String message = Context.getMessageText(EX_UNSUPPORTED_SUBSYSTEM, cls.getName(), ex.getMessage());
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        throw new IllegalStateException(message);
    }

    public static void throwRegistrationFailed(Exception ex) throws ConfigurationException {
        throw new ConfigurationException(EX_REGISTRATION_FAILED, (Throwable)ex);
    }

    public static void throwInvalidContext(Exception ex) throws ConfigurationException {
        throw new ConfigurationException(EX_INVALID_CONTEXT, (Throwable)ex);
    }

    public static void throwConfigNotFound(String name) throws ConfigurationException {
        throw new ConfigurationException(EX_CONFIG_NOT_FOUND, new Object[]{name});
    }
}

