/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBSubsystem;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.ConverterHandler;
import com.raplix.rolloutexpress.ui.PackageInfo;
import com.raplix.rolloutexpress.ui.Serializer;
import com.raplix.rolloutexpress.ui.UIApplication;
import com.raplix.rolloutexpress.ui.UIContextServices;
import com.raplix.rolloutexpress.ui.UISubsystem;
import com.raplix.rolloutexpress.ui.clui.CLUISubsystem;
import com.raplix.rolloutexpress.ui.converters.CollectionHandler;
import com.raplix.rolloutexpress.ui.converters.DirectHandler;
import com.raplix.rolloutexpress.ui.converters.NullHandler;
import com.raplix.rolloutexpress.ui.converters.SerialHandler;
import com.raplix.util.DelayedCreator;
import com.raplix.util.logger.Logger;

public class BasicContext {
    private static UIApplication sApplication;
    private static ServerAddressCreator sServerAddress;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$Context;

    protected BasicContext() {
    }

    public static void setApp(UIApplication application) {
        sApplication = application;
    }

    public static UIApplication getApp() {
        return sApplication;
    }

    public static String getMessageText(String key) {
        return ROXMessageManager.messageAsString(key);
    }

    public static String getMessageText(String key, Object arg) {
        return ROXMessageManager.messageAsString(key, new Object[]{arg});
    }

    public static String getMessageText(String key, Object arg1, Object arg2) {
        return ROXMessageManager.messageAsString(key, new Object[]{arg1, arg2});
    }

    public static UIContextServices getUIContextServices() {
        return sApplication.getUIContextServices();
    }

    public static NetSubsystem getNetSubsystem() {
        return sApplication.getNetSubsystem();
    }

    public static RemoteUserDBSubsystem getRemoteUserDBSubsystem() {
        return sApplication.getRemoteUserDBSubsystem();
    }

    public static UISubsystem getUISubsystem() {
        return sApplication.getUISubsystem();
    }

    public static CLUISubsystem getCLUISubsystem() {
        try {
            return sApplication.getCLUISubsystem();
        }
        catch (UnsupportedSubsystemException ex) {
            PackageInfo.throwUnsupportedSubsystem(CLUISubsystem.class, ex);
            return null;
        }
    }

    public static RoxAddress getServerAddress() {
        return (RoxAddress)sServerAddress.getValue();
    }

    public static ConverterHandler getConverterHandler() {
        return BasicContext.getUISubsystem().getConverterHandler();
    }

    public static Serializer getSerializer() {
        return BasicContext.getUISubsystem().getSerializer();
    }

    public static ConverterHandler toHandler(Converter c) {
        DirectHandler exactHandler = new DirectHandler();
        exactHandler.addConverter(c);
        SerialHandler result = new SerialHandler();
        result.addHandler(new CollectionHandler(new NullHandler(exactHandler)));
        return result;
    }

    public static Object convert(Object src, Class dstCls, Converter c) throws Exception {
        return BasicContext.toHandler(c).convert(src, dstCls);
    }

    static {
        sServerAddress = new ServerAddressCreator();
    }

    private static class ServerAddressCreator
    extends DelayedCreator {
        private ServerAddressCreator() {
        }

        protected Object create() {
            ConnectionSetupAttribute[] c = null;
            try {
                c = BasicContext.getNetSubsystem().getClientConnAttributes();
            }
            catch (ConfigurationException ex) {
                PackageInfo.throwServerNotFound(ex);
            }
            if (c.length <= 0) {
                PackageInfo.throwServerNotFound();
            }
            RoxAddress serverAddress = null;
            try {
                serverAddress = new RoxAddress(c[0].getAddress(), c[0].getPort());
            }
            catch (TransportException ex) {
                PackageInfo.throwServerNotFound(ex);
            }
            if (Logger.isDebugEnabled(class$com$raplix$rolloutexpress$ui$Context == null ? (class$com$raplix$rolloutexpress$ui$Context = BasicContext.class$("com.raplix.rolloutexpress.ui.Context")) : class$com$raplix$rolloutexpress$ui$Context)) {
                Logger.debug("Obtained server address '" + serverAddress + "'", class$com$raplix$rolloutexpress$ui$Context == null ? (class$com$raplix$rolloutexpress$ui$Context = BasicContext.class$("com.raplix.rolloutexpress.ui.Context")) : class$com$raplix$rolloutexpress$ui$Context);
            }
            return serverAddress;
        }
    }
}

