/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupGraphTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupMemberTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserData;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserDataTable;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUser;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

class UserTable
extends PersistentUserDataTable {
    public static final UserTable DEFAULT = new UserTable(null);

    public UserTable(String alias) {
        super(alias);
    }

    public RemoteUser[] execute(Select query) throws UserDBException {
        if (query == null) {
            return null;
        }
        try {
            PersistentBean[] users = UserTable.executeMultiResult(query, this);
            RemoteUser[] result = new RemoteUser[users.length];
            for (int i = 0; i < users.length; ++i) {
                PersistentUserData user = (PersistentUserData)users[i];
                result[i] = new RemoteUser(user.getUserID(), user.toUserData());
            }
            return result;
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    public RemoteUser[] executeSelectAll() throws UserDBException {
        return this.execute(UserTable.select((SelectList)this.allColumns(), UserTable.tList(this), UserTable.where(UserTable.not(UserTable.equals(this.ID, UserID.USER_SENTINEL_ID))), UserTable.dictOrderAsc(this.Username)));
    }

    public RemoteUser[] executeSelectByUsername(String username) throws UserDBException {
        return this.execute(this.selectByUsername(username));
    }

    public Select selectByUsername(String username) {
        return this.select(UserTable.where(UserTable.equals(this.Username, username)));
    }

    public RemoteUser[] executeSelectByGroup(GroupID groupID) throws UserDBException {
        return this.execute(this.selectByGroup(groupID));
    }

    public Select selectByGroup(GroupID groupID) {
        GroupMemberTable gmt = GroupMemberTable.DEFAULT;
        return this.select(UserTable.where(UserTable.in((ColumnNode)this.ID, gmt.selectUsersByGroup(groupID))));
    }

    public RemoteUser[] executeSelectByMembership(GroupID groupID) throws UserDBException {
        return this.execute(this.selectByMembership(groupID));
    }

    public Select selectByMembership(GroupID groupID) {
        GroupMemberTable gmt = GroupMemberTable.DEFAULT;
        Select groupMembers = gmt.selectMembersByGroup(groupID);
        return this.select((SelectList)this.allColumns(), UserTable.where(UserTable.and(UserTable.or(this.isAncestorOfRegistered(groupID), UserTable.in((ColumnNode)this.ID, groupMembers)), UserTable.not(UserTable.equals(this.ID, UserID.USER_SENTINEL_ID)))), this.orderByNameAsc());
    }

    private ConditionalExpression isAncestorOfRegistered(GroupID group) {
        GroupGraphTable ggt = GroupGraphTable.DEFAULT;
        return ggt.isDescendantOf(group, RemoteGroupManager.REGISTERED_GROUPID);
    }

    public int updateUsersByGroup(GroupID groupID) throws PersistenceManagerException {
        GroupMemberTable gmt = GroupMemberTable.DEFAULT;
        Select userIDs = gmt.selectUsersByGroup(groupID);
        return UserTable.execute(this.update(UserTable.uList(UserTable.increment(this.UpdateCount)), UserTable.where(UserTable.in((ColumnNode)this.ID, userIDs))));
    }

    public int updateUsersByID(UserID[] userIDs) throws PersistenceManagerException {
        return UserTable.execute(this.update(UserTable.uList(UserTable.increment(this.UpdateCount)), UserTable.where(UserTable.in((ColumnNode)this.ID, UserTable.rList(userIDs)))));
    }

    public ScalarExp isSysUser() {
        return UserTable.equals(this.ID, RemoteUserManager.ADMIN_USERID);
    }

    public OrderByList orderByNameAsc() {
        return UserTable.oList(UserTable.orderByDesc(this.isSysUser())).add(UserTable.dictOrderAsc(this.Username));
    }

    public OrderByList orderByNameDesc() {
        return UserTable.oList(UserTable.orderByDesc(this.isSysUser())).add(UserTable.dictOrderDesc(this.Username));
    }

    public int executeSetSessionVarDetect(UserID inUserID) throws PersistenceManagerException {
        return UserTable.execute(this.update(UserTable.uList(UserTable.set(this.SessionVarDetect, true), UserTable.increment(this.UpdateCount)), UserTable.where(UserTable.equals(this.ID, inUserID))));
    }
}

