/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.ClearSessionVarsException;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupMemberTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.InvalidChangeException;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserData;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUser;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserManager;
import com.raplix.rolloutexpress.systemmodel.userdb.Session;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarImplSQLOps;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.userdb.SingleSessionVariableSetQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserData;
import com.raplix.rolloutexpress.systemmodel.userdb.UserEvent;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserListener;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.UserService;
import com.raplix.rolloutexpress.systemmodel.userdb.UserTable;
import com.raplix.util.ObjectUtil;
import com.raplix.util.string.StringUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

class UserServicesImpl
implements UserManagerService,
UserService {
    private static final String MSG_INVALID_PASSWORD = "userdb.usi.INVALID_PASSWORD";
    private static final String MSG_UNKNOWN_ERROR = "userdb.usi.UNKNOWN_ERROR";
    private static final String MSG_INVALID_USERNAME = "userdb.usi.INVALID_USERNAME";
    private static final String MSG_SYSTEM_USER_DELETE = "userdb.usi.SYSTEM_USER_DELETE";
    private static final String MSG_ADMIN_GROUP_REMOVE = "userdb.usi.ADMIN_GROUP_REMOVE";
    private static final String MSG_INVALID_ADMIN_LOGIN_CONFIG = "userdb.usi.INVALID_ADMIN_LOGIN_CONFIG";
    private static final String MSG_PASSWORD_NOT_SPECIFIED = "userdb.usi.PASSWORD_NOT_SPECIFIED";
    private static final String MSG_PASSWORD_SPECIFIED = "userdb.usi.PASSWORD_SPECIFIED";
    private static final String MSG_CHG_PWD_INVALID_LOGIN_CONFIG = "userdb.usi.CHG_PWD_INVALID_LOGIN_CONFIG";
    private static final String MSG_CHG_PWD_NONINT_LOGIN_CONFIG = "userdb.usi.CHG_PWD_NONINT_LOGIN_CONFIG";
    private AdminServicesManager mManager;
    private Vector mListeners = new Vector();
    private static final int MAX_PASSWORD_LENGTH = 32;

    UserServicesImpl(AdminServicesManager manager) {
        this.setManager(manager);
    }

    public AdminServicesManager getManager() {
        return this.mManager;
    }

    private void setManager(AdminServicesManager manager) {
        this.mManager = manager;
    }

    private UserTable getUserTable() {
        return UserTable.DEFAULT;
    }

    private GroupTable getGroupTable() {
        return GroupTable.DEFAULT;
    }

    private GroupMemberTable getGroupMemberTable() {
        return GroupMemberTable.DEFAULT;
    }

    private Object transact(Transaction t) throws UserDBException {
        return this.getManager().transact(t);
    }

    public void addUserListener(UserListener listener) {
        this.mListeners.add(listener);
    }

    public void removeUserListener(UserListener listener) {
        this.mListeners.remove(listener);
    }

    private void notifyUserAdded(UserID userID) throws InvalidChangeException {
        UserEvent event = new UserEvent(userID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((UserListener)listeners.nextElement()).userAdded(event);
        }
    }

    private void notifyUserModified(UserID userID) throws InvalidChangeException {
        UserEvent event = new UserEvent(userID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((UserListener)listeners.nextElement()).userModified(event);
        }
    }

    private void notifyUserRemoved(UserID userID) throws InvalidChangeException {
        UserEvent event = new UserEvent(userID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((UserListener)listeners.nextElement()).userRemoved(event);
        }
    }

    public RemoteUser[] getAllUsers() throws UserDBException {
        return this.getUserTable().executeSelectAll();
    }

    public RemoteUser getUser(String username) throws UserDBException {
        RemoteUser[] results = this.getUserTable().executeSelectByUsername(username);
        if (results.length > 0) {
            return results[0];
        }
        return null;
    }

    public UserData getUserData(final UserID userID) throws UserDBException {
        try {
            if (userID.equals(this.getCurrentUserID())) {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws PersistenceManagerException {
                        return UserServicesImpl.this.getUserDataNative(userID);
                    }
                };
                return (UserData)this.doPrivileged(action);
            }
            return this.getUserDataNative(userID);
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    private UserID getCurrentUserID() {
        Session session = this.getManager().getUserDBSubsystem().getSessionTable().getCurrentSession();
        if (session == null) {
            return null;
        }
        return session.getUserID();
    }

    private UserData getUserDataNative(UserID userID) throws PersistenceManagerException {
        PersistentUserData result = new PersistentUserData(userID);
        result.retrieve();
        return result.toUserData();
    }

    public RemoteGroup[] getGroups(UserID userID) throws UserDBException {
        GroupTable gt = this.getGroupTable();
        return gt.executeSelectByUser(userID);
    }

    public void changePassword(String username, String origPwd, String newPwd) throws UserDBException, RPCException {
        final UserID userID = this.getManager().getUserDBSubsystem().getAuthenticator().authenticate(username, origPwd);
        UserServicesImpl.validatePassword(newPwd);
        final SessionVariableSet[] value = new SessionVariableSet[1];
        try {
            final UserData userData = (UserData)this.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        value[0] = SingleSessionVariableSetQuery.byUserID(userID).select();
                    }
                    catch (NoResultsFoundException noResultsFoundException) {
                        // empty catch block
                    }
                    return UserServicesImpl.this.getUserDataNative(userID);
                }
            });
            this.verifyIncludesInternal(userData.getLoginConfiguration());
            final SessionVariableSet encryptedSet = this.recryptVars(value[0], origPwd, newPwd);
            final HashedString newHashedPwd = this.getManager().getUserDBSubsystem().hash(username, newPwd);
            this.privTransact(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException, UserDBException {
                    UserServicesImpl.this.doChangePassword(userID, userData, newHashedPwd);
                    if (encryptedSet != null) {
                        encryptedSet.saveMS();
                    }
                    return null;
                }
            });
        }
        catch (PersistenceManagerException e) {
            AdminServicesManager.toUserDBException(e);
        }
    }

    private SessionVariableSet recryptVars(SessionVariableSet inValue, String origPwd, String newPwd) throws UserDBException {
        if (inValue != null) {
            inValue = inValue.decrypt(origPwd.toCharArray());
            inValue.ensureCanDetectPasswdChange();
            inValue = inValue.encrypt(newPwd.toCharArray());
        }
        return inValue;
    }

    private void verifyIncludesInternal(String inLoginConfiguration) throws UserDBException {
        LoginConfiguration loginConfig = this.getManager().getUserDBSubsystem().getLoginConfigForName(inLoginConfiguration);
        if (loginConfig == null) {
            throw new UserDBException(MSG_CHG_PWD_INVALID_LOGIN_CONFIG, loginConfig);
        }
        if (!loginConfig.includesInternal()) {
            throw new UserDBException(MSG_CHG_PWD_NONINT_LOGIN_CONFIG, loginConfig);
        }
    }

    private Object doPrivileged(PrivilegedExceptionAction action) throws PersistenceManagerException {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof PersistenceManagerException) {
                throw (PersistenceManagerException)e;
            }
            throw new PersistenceManagerException(new ROXMessage(MSG_UNKNOWN_ERROR), (Throwable)e, 1);
        }
    }

    private Object privTransact(final PrivilegedExceptionAction action) throws UserDBException {
        return this.transact(new Transaction(){

            public Object execute() throws PersistenceManagerException, SQLException {
                return UserServicesImpl.this.doPrivileged(action);
            }
        });
    }

    private void doChangePassword(UserID userID, UserData userData, HashedString newPwd) throws PersistenceManagerException {
        userData.setPassword(newPwd);
        this.saveUserData(userID, userData);
    }

    public UserID save(final UserID userID, final UserData userData, final GroupID[] groups, boolean forceClearVars) throws UserDBException {
        boolean includesInternal;
        if (userID == null || userData != null) {
            this.validate(userData);
        }
        if (RemoteUserManager.ADMIN_USERID.equals(userID)) {
            if (groups != null) {
                this.verifyContainsAdminGroup(groups);
            }
            if (!"internal".equals(userData.getLoginConfiguration())) {
                throw new UserDBException(MSG_INVALID_ADMIN_LOGIN_CONFIG, userData.getLoginConfiguration());
            }
            includesInternal = true;
        } else {
            includesInternal = this.mManager.getUserDBSubsystem().validateLoginConfig(userData.getLoginConfiguration());
        }
        if (includesInternal) {
            if (userData.getPassword() == null) {
                throw new UserDBException(MSG_PASSWORD_NOT_SPECIFIED, userData.getLoginConfiguration());
            }
        } else if (userData.getPassword() != null) {
            throw new UserDBException(MSG_PASSWORD_SPECIFIED, userData.getLoginConfiguration());
        }
        UserData oldUserData = null;
        boolean deleteSessionVariables = false;
        if (userID != null) {
            boolean isPasswdChanged;
            boolean isLoginConfigChanged;
            oldUserData = this.getUserData(userID);
            boolean bl = isLoginConfigChanged = !userData.getLoginConfiguration().equals(oldUserData.getLoginConfiguration());
            if (isLoginConfigChanged) {
                UserDBSubsystem userDBSubsystem = this.getManager().getUserDBSubsystem();
                LoginConfiguration newConfig = userDBSubsystem.getLoginConfigForName(userData.getLoginConfiguration());
                LoginConfiguration oldConfig = userDBSubsystem.getLoginConfigForName(oldUserData.getLoginConfiguration());
                if (newConfig != null && newConfig.includesInternal() && oldConfig != null && oldConfig.includesInternal()) {
                    isLoginConfigChanged = false;
                }
            }
            boolean bl2 = isPasswdChanged = !ObjectUtil.equals(userData.getPassword(), oldUserData.getPassword());
            if ((isLoginConfigChanged || isPasswdChanged) && userData.isClearSessionVarsOnLoginConfigChange()) {
                if (forceClearVars) {
                    deleteSessionVariables = true;
                    userData.setIsClearSessionVarsOnLoginConfigChange(false);
                } else {
                    throw new ClearSessionVarsException(new Integer(isLoginConfigChanged ? 0 : 1));
                }
            }
        }
        final boolean clearSessionVars = deleteSessionVariables;
        return (UserID)this.transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                return UserServicesImpl.this.transactSave(userID, userData, groups, clearSessionVars);
            }
        });
    }

    private UserID transactSave(UserID userID, UserData userData, GroupID[] groups, boolean deleteSessionVariables) throws PersistenceManagerException {
        boolean isNew;
        boolean bl = isNew = userID == null;
        if (isNew) {
            userID = this.saveUserData(userID, userData);
        }
        if (groups != null) {
            if (!isNew) {
                this.deleteGroupMembers(userID);
            }
            if (groups.length > 0) {
                this.insertGroupMembers(groups, userID);
            }
        }
        if (isNew) {
            this.notifyUserAdded(userID);
        } else {
            this.saveUserData(userID, userData);
            if (deleteSessionVariables) {
                SessionVarImplSQLOps.DEFAULT.deleteForUser(userID);
                SessionVariableSetSQLOps.DEFAULT.delete(userID);
            }
            this.notifyUserModified(userID);
        }
        return userID;
    }

    private void verifyContainsAdminGroup(GroupID[] groups) throws UserDBException {
        if (!Arrays.asList(groups).contains(RemoteGroupManager.ADMIN_GROUPID)) {
            throw new UserDBException(MSG_ADMIN_GROUP_REMOVE);
        }
    }

    private UserID saveUserData(UserID userID, UserData userData) throws PersistenceManagerException {
        PersistentUserData pData = new PersistentUserData(userID, userData);
        pData.save();
        return pData.getUserID();
    }

    private void validate(UserData userData) throws UserDBException {
        if (userData == null) {
            throw new UserDBException(MSG_INVALID_USERNAME, null);
        }
        String name = userData.getUsername();
        if (!this.isValidUsername(name)) {
            throw new UserDBException(MSG_INVALID_USERNAME, name);
        }
    }

    private boolean isValidUsername(String name) {
        return this.getManager().isValidName(name, 1);
    }

    static void validatePassword(String pwd) throws UserDBException {
        if (StringUtil.isEmpty(pwd) || pwd.length() > 32) {
            throw new UserDBException(MSG_INVALID_PASSWORD);
        }
    }

    private void insertGroupMembers(GroupID[] groups, UserID user) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByID(groups);
        this.getGroupMemberTable().insert(groups, user);
    }

    public void delete(final UserID userID) throws UserDBException {
        if (RemoteUserManager.isSystemUser(userID) || UserID.USER_SENTINEL_ID.equals(userID)) {
            throw new UserDBException(MSG_SYSTEM_USER_DELETE);
        }
        this.transact(new Transaction(){

            public Object execute() throws SQLException, PersistenceManagerException {
                UserServicesImpl.this.transactDelete(userID);
                return null;
            }
        });
    }

    private void transactDelete(UserID userID) throws PersistenceManagerException {
        this.deleteGroupMembers(userID);
        SessionVarImplSQLOps.DEFAULT.deleteForUser(userID);
        SessionVariableSetSQLOps.DEFAULT.delete(userID);
        new PersistentUserData(userID).delete();
        this.notifyUserRemoved(userID);
    }

    private void deleteGroupMembers(UserID userID) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByUser(userID);
        this.getGroupMemberTable().deleteByUser(userID);
    }
}

