/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserData;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;

public class UserID
extends ObjectID {
    public static final UserID USER_SENTINEL_ID = new UserID("010010001019-0000000000000-00001-0000000001");
    private static final PersistentUserData.IDFactory ID_FACTORY = new PersistentUserData.IDFactory();

    private UserID() {
    }

    public UserID(String ID2) {
        super(ID2);
    }

    public static UserID generateUserID() {
        return ID_FACTORY.generateUserID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            UserID.validateForDeactivation(this, this.getUserManager());
        }
        catch (UserDBException udbe) {
            throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        UserIDSet idset = new UserIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        try {
            User thisUser = this.getUserManager().getUser(this);
            thisUser.setActive(false);
            thisUser.save(true);
        }
        catch (CommandException ce) {
            throw new PersistenceManagerException(ce);
        }
    }

    protected UserManager getUserManager() throws UserDBException {
        try {
            return Application.getApp().getUserDBSubsystem().getLocalUserDBAdmin().getUserManager();
        }
        catch (UnsupportedSubsystemException use) {
            throw new UserDBException(use);
        }
    }

    static void validateForDeactivation(UserID inUserID, UserManager inUserManager) throws UserDBException {
        if (USER_SENTINEL_ID.equals(inUserID)) {
            throw new UserDBException("userdb.CANNOT_DEACTIVATE_SENTINEL");
        }
        if (inUserManager.getAdminUserID().equals(inUserID)) {
            throw new UserDBException("userdb.CANNOT_DEACTIVATE_ADMIN");
        }
    }
}

