/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

public class UserFolderPermissions {
    private boolean mWrite;
    private boolean mAutorun;
    private boolean mCheckin;
    private boolean mOwner;
    private FolderID mFolderID;
    private UserID mUserID;
    private HostSetIDSet mExecuteHostSets;
    private boolean mExecuteAllHosts;
    private HostSetIDSet mDelHistoryHostSets;
    private boolean mDelHistoryAllHosts;

    public boolean isWrite() {
        return this.mWrite;
    }

    public boolean isAutorun() {
        return this.mAutorun;
    }

    public boolean isCheckin() {
        return this.mCheckin;
    }

    public boolean isOwner() {
        return this.mOwner;
    }

    public FolderID getFolderID() {
        return this.mFolderID;
    }

    public UserID getUserID() {
        return this.mUserID;
    }

    public HostSetIDSet getExecuteHostSets() {
        return (HostSetIDSet)this.mExecuteHostSets.clone();
    }

    public boolean isExecuteAllHosts() {
        return this.mExecuteAllHosts;
    }

    public HostSetIDSet getDeleteHistoryHostSets() {
        return this.mDelHistoryHostSets;
    }

    public boolean isDeleteHistoryAllHosts() {
        return this.mDelHistoryAllHosts;
    }

    UserFolderPermissions(FolderID inFolderID, UserID inUserID, boolean inWrite, boolean inAutorun, boolean inCheckin, boolean inOwner, HostSetIDSet inExecuteHostSets, boolean inExecuteAllHosts, HostSetIDSet inDelHistoryHostSets, boolean inDelHistoryAllHosts) {
        this.mWrite = inWrite;
        this.mAutorun = inAutorun || this.mWrite;
        this.mCheckin = inCheckin || this.mWrite;
        this.mOwner = inOwner;
        this.mFolderID = inFolderID;
        this.mUserID = inUserID;
        this.mExecuteHostSets = (HostSetIDSet)inExecuteHostSets.clone();
        this.mExecuteAllHosts = inExecuteAllHosts;
        this.mDelHistoryHostSets = (HostSetIDSet)inDelHistoryHostSets.clone();
        this.mDelHistoryAllHosts = inDelHistoryAllHosts;
    }

    public String toString() {
        return "UserFolderPermissions{mWrite=" + this.mWrite + ", mAutorun=" + this.mAutorun + ", mCheckin=" + this.mCheckin + ", mOwner=" + this.mOwner + ", mFolderID=" + this.mFolderID + ", mUserID=" + this.mUserID + ", mExecuteHostSets=" + this.mExecuteHostSets + ", mExecuteAllHosts=" + this.mExecuteAllHosts + ", mDelHistoryHostSets=" + this.mDelHistoryHostSets + ", mDelHistoryAllHosts=" + this.mDelHistoryAllHosts + "}";
    }
}

