/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetUpdateListener;
import com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.Authenticator;
import com.raplix.rolloutexpress.systemmodel.userdb.DefaultAuthenticator;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessControlManagerImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionListener;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupEvent;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupListener;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupService;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupServicesImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.HostPermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.JAASConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionEvent;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionListener;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionService;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionServicesImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionListener;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManagerServiceImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.StringConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserEvent;
import com.raplix.rolloutexpress.systemmodel.userdb.UserListener;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.UserService;
import com.raplix.rolloutexpress.systemmodel.userdb.UserServicesImpl;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class UserDBSubsystem
extends RemoteUserDBSubsystem
implements StringConstants {
    private static final String MSG_NO_PERSISTENCE_MANAGER = "userdb.NO_PERSISTENCE_MANAGER";
    private static final String MSG_NO_NOTIFICATION_MANAGER = "userdb.NO_NOTIFICATION_MANAGER";
    private static final String MSG_UNREGISTERED_CLASS_MAP = "userdb.UNREGISTERED_CLASS_MAP";
    private static final String MSG_SERVICE_REG_ERROR = "userdb.SERVICE_REG_ERROR";
    private static final String MSG_NO_LOCAL_ADMIN = "userdb.NO_LOCAL_ADMIN";
    private static final String MSG_NO_LOCAL_SESSION_MANAGER = "userdb.NO_LOCAL_SESSION_MANAGER";
    private static final String MSG_SESSION_VALIDATOR_REG_ERROR = "userdb.SESSION_VALIDATOR_REG_ERROR";
    private static final String MSG_SESSION_MANAGER_REG_ERROR = "userdb.SESSION_MANAGER_REG_ERROR";
    private static final String MSG_ACCESS_CONTROL_PROVIDER_REG_ERROR = "userdb.ACCESS_CONTROL_PROVIDER_REG_ERROR";
    private static final String MSG_SUBSYSTEM_NAME = "userdb.SUBSYSTEM_NAME";
    private static final String MSG_INVALID_LOGIN_CONFIG = "userdb.INVALID_LOGIN_CONFIG";
    public static final String CONFIG_VARNAME_SESSION_TIMEOUT = "userdb.sessionTimeout";
    private static final int DEFAULT_CONFIG_SESSION_TIMEOUT = 1800000;
    public static final String CONFIG_VARNAME_REAPER_INTERVAL = "userdb.reaperInterval";
    private static final int DEFAULT_CONFIG_REAPER_INTERVAL = 3600000;
    public static final String CONFIG_VARNAME_AUTH_MODULES = "userdb.authModules";
    private static final String DEFAULT_CONFIG_AUTH_MODULES = "internal";
    public static final String CONFIG_VARNAME_SESSION_VAR_PERSIST = "userdb.enableSessionVariablePersist";
    private static final boolean DEFAULT_CONFIG_SESSION_VAR_PERSIST = true;
    private static DefaultConfiguration[] sDefaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration("userdb.sessionTimeout", 1800000, DOC_CONFIG_SESSION_TIMEOUT), new DefaultConfiguration("userdb.reaperInterval", 3600000, DOC_CONFIG_REAPER_INTERVAL), new DefaultConfiguration("userdb.enableSessionVariablePersist", true, DOC_CONFIG_SESSION_VAR_PERSIST), new DefaultConfiguration("userdb.authModules", "internal", DOC_CONFIG_AUTH_MODULES)};
    private Hashtable mLoginConfigs = new Hashtable();
    private LoginConfiguration[] mOrderedConfigs;
    private RemoteUserDBAdmin mLocalUserDBAdmin;
    private SessionManager mLocalSessionManager;
    private AccessControlManager mAccessControlManager;
    private Authenticator mAuthenticator;
    private SessionTable mSessionTable;
    private AdminServicesManager mAdminServicesManager;
    private FolderAccessControlManagerImpl mFolderAccessControlManager;
    static /* synthetic */ Class class$com$sun$n1$sps$userdb$UserDBLoginModule;

    private UserDBSubsystem() {
    }

    public UserDBSubsystem(Application inApplication) throws ConfigurationException {
        this(inApplication, null, true, null);
    }

    public UserDBSubsystem(Application inApplication, PersistenceManager pm, boolean installAccessProvider, SessionListener listener) throws ConfigurationException {
        super(inApplication);
        if (pm == null) {
            pm = this.initPersistenceLayer(inApplication);
        }
        if (listener == null) {
            listener = this.initSessionListener(inApplication);
        }
        this.setAdminServicesManager(this.initAdminServices(pm, this.getRPCManager()));
        this.setLocalUserDBAdmin(this.initLocalUserDBAdmin());
        this.setAuthenticator(this.initAuthenticator());
        this.setSessionTable(this.initSessionServices(this.getRPCManager(), listener, pm));
        RPCManager rpc = installAccessProvider ? this.getRPCManager() : null;
        this.setFolderAccessControlManager(this.newFolderAccessManager());
        this.setAccessControlManager(this.initAccessControlManager(rpc, inApplication));
        this.setLocalSessionManager(this.initLocalSessionManager());
        this.initLoginConfigs();
        this.postSessionInit();
    }

    private void initLoginConfigs() throws ConfigurationException {
        try {
            Configuration defaultConfig = Configuration.getConfiguration();
            if (defaultConfig instanceof JAASConfiguration) {
                defaultConfig = ((JAASConfiguration)defaultConfig).getDelegate();
            }
            defaultConfig.refresh();
            if (null != defaultConfig.getAppConfigurationEntry(DEFAULT_CONFIG_AUTH_MODULES)) {
                throw new ConfigurationException("userdb.LOGIN_CONFIG_INTERNAL_INVALID");
            }
            Configuration.setConfiguration(new JAASConfiguration(defaultConfig));
            String loginConfigs = this.getConfigurationAsString(CONFIG_VARNAME_AUTH_MODULES);
            if (StringUtil.isEmpty(loginConfigs)) {
                throw new ConfigurationException("userdb.NO_LOGIN_CONFIG");
            }
            String[] configs = loginConfigs.split(",");
            LinkedList list = new LinkedList();
            for (int i = 0; i < configs.length; ++i) {
                this.validateAndAddLoginConfig(list, configs[i]);
            }
            if (this.mLoginConfigs.isEmpty()) {
                throw new ConfigurationException("userdb.NO_LOGIN_CONFIG");
            }
            this.mOrderedConfigs = list.toArray(new LoginConfiguration[list.size()]);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("userdb.ERR_INIT_LOGIN_CONFIG", (Throwable)e);
        }
    }

    private void validateAndAddLoginConfig(LinkedList list, String inLoginConfigName) throws ConfigurationException {
        if (this.mLoginConfigs.containsKey(inLoginConfigName)) {
            throw new ConfigurationException("userdb.DUPLICATE_LOGIN_CONFIG", new Object[]{inLoginConfigName});
        }
        AppConfigurationEntry[] configs = Configuration.getConfiguration().getAppConfigurationEntry(inLoginConfigName);
        if (configs == null) {
            throw new ConfigurationException("userdb.LOGIN_CONFIG_NOT_CONFIGURED", new Object[]{inLoginConfigName});
        }
        boolean includesInternal = false;
        for (int i = 0; i < configs.length; ++i) {
            if (!(class$com$sun$n1$sps$userdb$UserDBLoginModule == null ? UserDBSubsystem.class$("com.sun.n1.sps.userdb.UserDBLoginModule") : class$com$sun$n1$sps$userdb$UserDBLoginModule).getName().equals(configs[i].getLoginModuleName())) continue;
            includesInternal = true;
            break;
        }
        LoginConfiguration loginConfig = new LoginConfiguration(inLoginConfigName, includesInternal);
        list.add(loginConfig);
        this.mLoginConfigs.put(inLoginConfigName, loginConfig);
    }

    boolean validateLoginConfig(String loginConfigName) throws UserDBException {
        LoginConfiguration loginConfig;
        if (loginConfigName == null || (loginConfig = this.getLoginConfigForName(loginConfigName)) == null) {
            throw new UserDBException(new ROXMessage(MSG_INVALID_LOGIN_CONFIG, loginConfigName, Util.getStringFromArray(this.mLoginConfigs.keySet().toArray(), ",")), null, 0);
        }
        return loginConfig.includesInternal();
    }

    protected FolderAccessControlManagerImpl newFolderAccessManager() {
        return new FolderAccessControlManagerImpl(this);
    }

    private PersistenceManager initPersistenceLayer(Application app) throws ConfigurationException {
        PersistenceManager pm;
        try {
            pm = app.getPMSubsystem();
        }
        catch (UnsupportedSubsystemException e) {
            throw this.configError(MSG_NO_PERSISTENCE_MANAGER, e);
        }
        return pm;
    }

    private SessionListener initSessionListener(Application app) throws ConfigurationException {
        try {
            return new SessionListener.Notifier(app.getNotificationManager());
        }
        catch (UnsupportedSubsystemException e) {
            throw this.configError(MSG_NO_NOTIFICATION_MANAGER, e);
        }
    }

    private AdminServicesManager initAdminServices(PersistenceManager pm, RPCManager rpc) throws ConfigurationException {
        AdminServicesManager services = null;
        try {
            services = new AdminServicesManager(pm, this);
        }
        catch (ClassMapException e) {
            throw this.configError(MSG_UNREGISTERED_CLASS_MAP, e);
        }
        try {
            GroupServicesImpl groupServices = services.getGroupServices();
            rpc.registerService(GroupManagerService.class, groupServices);
            rpc.registerService(GroupService.class, groupServices);
            UserServicesImpl userServices = services.getUserServices();
            rpc.registerService(UserManagerService.class, userServices);
            rpc.registerService(UserService.class, userServices);
            PermissionServicesImpl permissionServices = services.getPermissionServices();
            rpc.registerService(PermissionManagerService.class, permissionServices);
            rpc.registerService(PermissionService.class, permissionServices);
        }
        catch (RPCException e) {
            throw this.configError(MSG_SERVICE_REG_ERROR, e);
        }
        return services;
    }

    private RemoteUserDBAdmin initLocalUserDBAdmin() throws ConfigurationException {
        try {
            return (RemoteUserDBAdmin)this.getUserDBAdmin(RoxAddress.local);
        }
        catch (RPCException e) {
            throw this.configError(MSG_NO_LOCAL_ADMIN, e);
        }
    }

    private void postSessionInit() throws ConfigurationException {
        try {
            this.mLocalUserDBAdmin.initSessionServices(this.getRPCManager(), RoxAddress.local);
        }
        catch (RPCException e) {
            throw this.configError(MSG_NO_LOCAL_ADMIN, e);
        }
    }

    public UserDBAdmin getLocalUserDBAdmin() {
        return this.mLocalUserDBAdmin;
    }

    private void setLocalUserDBAdmin(RemoteUserDBAdmin admin) {
        this.mLocalUserDBAdmin = admin;
    }

    private SessionManager initLocalSessionManager() throws ConfigurationException {
        try {
            return this.getSessionManager(RoxAddress.local);
        }
        catch (RPCException e) {
            throw this.configError(MSG_NO_LOCAL_SESSION_MANAGER, e);
        }
    }

    public SessionManager getLocalSessionManager() {
        return this.mLocalSessionManager;
    }

    private void setLocalSessionManager(SessionManager admin) {
        this.mLocalSessionManager = admin;
    }

    private Authenticator initAuthenticator() {
        return new DefaultAuthenticator(this);
    }

    private SessionTable initSessionServices(RPCManager rpc, SessionListener listener, PersistenceManager inPM) throws ConfigurationException {
        SessionTable sessionTable;
        try {
            sessionTable = new SessionTable(rpc.getContextManager(), this.getConfigSessionTimeout(), this.getConfigReaperInterval());
        }
        catch (ContextException e) {
            throw this.configError(MSG_SESSION_VALIDATOR_REG_ERROR, e);
        }
        SessionManagerServiceImpl sessionManager = new SessionManagerServiceImpl(this, this.getAuthenticator(), sessionTable, listener, inPM);
        try {
            rpc.registerService(SessionManagerService.class, sessionManager);
        }
        catch (RPCException e) {
            throw this.configError(MSG_SESSION_MANAGER_REG_ERROR, e);
        }
        return sessionTable;
    }

    private AccessControlManager initAccessControlManager(RPCManager rpc, Application ctx) throws ConfigurationException {
        try {
            PermissionManager manager = this.getLocalUserDBAdmin().getPermissionManager();
            AccessControlManager result = new AccessControlManager(this.getSessionTable(), manager, rpc, ctx);
            AccessControlInvalidator invalidator = new AccessControlInvalidator(result);
            this.addUserListener(invalidator);
            this.addGroupListener(invalidator);
            this.addPermissionListener(invalidator);
            this.addFolderListener(invalidator);
            return result;
        }
        catch (RPCException e) {
            throw this.configError(MSG_ACCESS_CONTROL_PROVIDER_REG_ERROR, e);
        }
    }

    public AccessControlManager getAccessControlManager() {
        return this.mAccessControlManager;
    }

    private void setAccessControlManager(AccessControlManager accessControlManager) {
        this.mAccessControlManager = accessControlManager;
    }

    public void shutdown() {
        this.getSessionTable().shutdown();
    }

    Authenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    private void setAuthenticator(Authenticator authenticator) {
        this.mAuthenticator = authenticator;
    }

    public SessionTable getSessionTable() {
        return this.mSessionTable;
    }

    private void setSessionTable(SessionTable sessionTable) {
        this.mSessionTable = sessionTable;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        return sDefaultConfiguration;
    }

    public HostSetUpdateListener getHostPermissionManager(Class permClass) {
        PermissionManager permMan = this.getLocalUserDBAdmin().getPermissionManager();
        return new HostPermissionManager(permMan, permClass);
    }

    public void addUserListener(UserListener listener) {
        this.getAdminServicesManager().getUserServices().addUserListener(listener);
    }

    public void removeUserListener(UserListener listener) {
        this.getAdminServicesManager().getUserServices().removeUserListener(listener);
    }

    public void addGroupListener(GroupListener listener) {
        this.getAdminServicesManager().getGroupServices().addGroupListener(listener);
    }

    public void removeGroupListener(GroupListener listener) {
        this.getAdminServicesManager().getGroupServices().removeGroupListener(listener);
    }

    public void addPermissionListener(PermissionListener listener) {
        this.getAdminServicesManager().getPermissionServices().addPermissionListener(listener);
    }

    public void removePermissionListener(PermissionListener listener) {
        this.getAdminServicesManager().getPermissionServices().removePermissionListener(listener);
    }

    void addFolderListener(FolderPermissionListener listener) {
        this.mFolderAccessControlManager.addListener(listener);
    }

    void removeFolderListener(FolderPermissionListener listener) {
        this.mFolderAccessControlManager.removeListener(listener);
    }

    public int getConfigSessionTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_SESSION_TIMEOUT);
    }

    public int getConfigReaperInterval() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_REAPER_INTERVAL);
    }

    public boolean getConfigSessionVariablePersist() throws ConfigurationException {
        return this.getConfigurationAsBoolean(CONFIG_VARNAME_SESSION_VAR_PERSIST);
    }

    public LoginConfiguration[] getAuthModules() {
        return this.mOrderedConfigs;
    }

    LoginConfiguration getLoginConfigForName(String inLoginConfigName) {
        return (LoginConfiguration)this.mLoginConfigs.get(inLoginConfigName);
    }

    public FolderAccessControlManager getFolderAccessControlManager() {
        return this.mFolderAccessControlManager;
    }

    public static String getClassSubsystemName() {
        return ROXMessageManager.messageAsString(MSG_SUBSYSTEM_NAME);
    }

    public String getSubsystemName() {
        return UserDBSubsystem.getClassSubsystemName();
    }

    AdminServicesManager getAdminServicesManager() {
        return this.mAdminServicesManager;
    }

    private void setAdminServicesManager(AdminServicesManager adminServicesManager) {
        this.mAdminServicesManager = adminServicesManager;
    }

    private void setFolderAccessControlManager(FolderAccessControlManagerImpl inFolderAccessControlManager) throws ConfigurationException {
        block3: {
            try {
                HostDBSubsystem hostDBSubsystem = this.getApplication().getHostDBSubsystem();
                if (hostDBSubsystem == null) {
                    throw new ConfigurationException("userdb.HOSTDB_NOT_INITIALIZED");
                }
                hostDBSubsystem.addHostSetUpdateListener(inFolderAccessControlManager);
            }
            catch (UnsupportedSubsystemException e) {
                if (!Logger.isErrorEnabled(this)) break block3;
                Logger.error("Error Registering host set update listener", e, this);
            }
        }
        this.mFolderAccessControlManager = inFolderAccessControlManager;
    }

    private static class AccessControlInvalidator
    implements UserListener,
    GroupListener,
    PermissionListener,
    FolderPermissionListener {
        private AccessControlManager mAccessControlManager;

        AccessControlInvalidator(AccessControlManager acm) {
            this.mAccessControlManager = acm;
        }

        public void userAdded(UserEvent event) {
        }

        public void userModified(UserEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void userRemoved(UserEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void groupAdded(GroupEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void groupModified(GroupEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void groupRemoved(GroupEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void permissionAdded(PermissionEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void permissionModified(PermissionEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void permissionRemoved(PermissionEvent event) {
            this.mAccessControlManager.invalidate();
        }

        public void folderPermsCreated(FolderID inFolderID) {
            this.mAccessControlManager.invalidate();
        }

        public void folderPermsUpdated(FolderID inFolderID) {
            this.mAccessControlManager.invalidate();
        }

        public void folderPermsDeleted(FolderID inFolderID) {
            this.mAccessControlManager.invalidate();
        }
    }
}

