/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXBasicPermissionBase;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.util.logger.Logger;
import java.security.Permission;

public class TaskPermission
extends ROXBasicPermissionBase
implements ROXPermission {
    public static final String OWNER_PREFIX = "owner.";
    public static final String USER_ALL = "*";

    public TaskPermission(String name) {
        super(name);
    }

    public TaskPermission(String name, String action) {
        super(name);
    }

    public TaskPermission(UserID inUserID) {
        this(TaskPermission.getPermissionName(inUserID));
    }

    static String getPermissionName(UserID inUserID) {
        return OWNER_PREFIX + inUserID;
    }

    public boolean implies(Permission permission) {
        return super.implies(permission);
    }

    protected ROXMessage getMessageMS() {
        String user;
        block8: {
            user = this.getName();
            if (user != null && user.length() > OWNER_PREFIX.length() && Character.isDigit((user = user.substring(OWNER_PREFIX.length())).charAt(0))) {
                boolean userResolved;
                block7: {
                    userResolved = false;
                    try {
                        PersistenceManager pm = PersistenceManager.getInstance();
                        if (pm != null) {
                            user = pm.getApplication().getUserDBSubsystem().getLocalUserDBAdmin().getUserManager().getUser(new UserID(user)).getUsername();
                            userResolved = true;
                        }
                    }
                    catch (Exception ignored) {
                        if (!Logger.isDebugEnabled(this)) break block7;
                        Logger.debug("Unable to resolve the user name through MS for ID:" + user, ignored, this);
                    }
                }
                if (!userResolved) {
                    try {
                        user = Context.getUserDBAdmin().getUserManager().getUser(new UserID(user)).getUsername();
                    }
                    catch (Exception ignored) {
                        if (!Logger.isDebugEnabled(this)) break block8;
                        Logger.debug("Unable to resolve the user name through CLI for ID:" + user, ignored, this);
                    }
                }
            }
        }
        return new ROXMessage("userdb.TASK_PERM", user);
    }
}

