/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotSavedQueryException;
import com.raplix.rolloutexpress.systemmodel.userdb.CipherServices;
import com.raplix.rolloutexpress.systemmodel.userdb.MultiSessionVarDescriptorQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDecryptionException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarImplSQLOps;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserTable;
import com.raplix.util.ObjectUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SessionVariableSet
extends PersistentBean
implements RPCSerializable,
Cloneable {
    private Hashtable mVars = new Hashtable();
    private boolean mIsVarTableCopy = true;
    private boolean mIsEncrypted = false;
    private boolean mIsDirty = false;
    private UserID mUserID;
    private SessionID mSessionID;
    static final String DETECT_PASSWD_CHANGE = "sys:detectpasschange";
    private boolean mVarsLoaded = false;
    private static final String DETECT_PASSWD_CHANGE_VALUE = "unchanged";

    public SessionVariable getVariable(String inName) {
        return DETECT_PASSWD_CHANGE.equals(inName) ? null : (SessionVariable)this.getVars().get(inName);
    }

    public boolean contains(String inVarName) {
        return !DETECT_PASSWD_CHANGE.equals(inVarName) && this.getVars().containsKey(inVarName);
    }

    public Set getVarNames() {
        HashSet set = new HashSet(this.getVars().keySet());
        set.remove(DETECT_PASSWD_CHANGE);
        return set;
    }

    public Collection getVariables() {
        Hashtable clone = (Hashtable)this.getVars().clone();
        clone.remove(DETECT_PASSWD_CHANGE);
        return Collections.unmodifiableCollection(clone.values());
    }

    public SessionVariable add(SessionVariable inVar) {
        if (inVar == null) {
            throw new NullPointerException();
        }
        return this.getModifiableVars().put(inVar.getName(), inVar);
    }

    public SessionVariable remove(String inVarName) {
        return this.remove(inVarName, false);
    }

    public SessionVariable remove(String inVarName, boolean removeDetectVar) {
        if (!removeDetectVar && DETECT_PASSWD_CHANGE.equals(inVarName)) {
            return null;
        }
        return (SessionVariable)this.getModifiableVars().remove(inVarName);
    }

    public boolean isDirty() {
        return this.mIsDirty;
    }

    private void setDirty(boolean dirty) {
        this.mIsDirty = dirty;
    }

    public boolean hasSecure() {
        Iterator iter = this.getVariables().iterator();
        while (iter.hasNext()) {
            if (!((SessionVariable)iter.next()).getSecure()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SessionVariableSet)) {
            return false;
        }
        SessionVariableSet set = (SessionVariableSet)obj;
        return this.getVars().equals(set.getVars()) && this.mIsDirty == set.mIsDirty && this.mIsEncrypted == set.mIsEncrypted && (this.mUserID == null ? set.mUserID == null : this.mUserID.equals(set.mUserID));
    }

    public int hashCode() {
        return this.getVars().hashCode();
    }

    UserID getUserID() {
        return this.mUserID;
    }

    public ObjectID getObjectID() {
        return super.getObjectID();
    }

    void saveMS() throws UserDBException {
        if (this.hasSecure() && !this.isEncrypted()) {
            throw new UserDBException("userdb.VARIABLES_NOT_SECURE");
        }
        if (!this.canDetectPasswdChange()) {
            throw new UserDBException("userdb.VARIABLES_NO_DETECT_PASSWORD");
        }
        try {
            final boolean setSessionVarDetect = PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getLocalUserDBAdmin().getUserManager().getUser(this.getUserID()).isClearSessionVarsOnLoginConfigChange() && this.canDetectPasswdChange();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException {
                    SessionVariableSet.transactMS(new Transaction(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object execute() throws PersistenceManagerException {
                            SessionVariableSet.access$200(1.access$100(this.this$1), 1.access$000(this.this$1));
                            return null;
                        }
                    });
                    return null;
                }

                static /* synthetic */ boolean access$000(1 x0) {
                    return x0.setSessionVarDetect;
                }

                static /* synthetic */ SessionVariableSet access$100(1 x0) {
                    return x0.SessionVariableSet.this;
                }
            });
            this.setDirty(false);
        }
        catch (RPCException e) {
            throw new UserDBException("userdb.ERR_SAVE_SESSION", (Throwable)e);
        }
        catch (UnsupportedSubsystemException e) {
            throw new UserDBException(e);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ObjectNotSavedQueryException) {
                throw new UserDBException(new ROXMessage("userdb.SESSION_VAR_MODIFIED"), e.getCause(), 0);
            }
            throw new UserDBException("userdb.ERR_SAVE_SESSION", e.getCause());
        }
    }

    private void trSaveMS(boolean setSessionVarDetect) throws PersistenceManagerException {
        SessionVariableSetID id = null;
        boolean isInsert = this.getObjectID() == null;
        super.saveMS(null);
        if (setSessionVarDetect && UserTable.DEFAULT.executeSetSessionVarDetect(this.getUserID()) != 1) {
            throw new PersistenceManagerException(new ROXMessage("userdb.UNABLE_SET_SESSION_VAR_DETECT", this.getUserID().toString()));
        }
        id = (SessionVariableSetID)this.getObjectID();
        if (!isInsert) {
            SessionVarImplSQLOps.DEFAULT.deleteSet(id);
        }
        Collection variables = this.getVars().values();
        SessionVariable[] vars = variables.toArray(new SessionVariable[variables.size()]);
        SessionVarImplSQLOps.DEFAULT.insertVars(id, vars);
    }

    synchronized void loadVarValues() throws PersistenceManagerException {
        if (!this.mVarsLoaded) {
            SessionVariable[] vars = SessionVarImplSQLOps.DEFAULT.selectVars((SessionVariableSetID)this.getObjectID());
            for (int i = 0; i < vars.length; ++i) {
                this.mVars.put(vars[i].getName(), vars[i]);
            }
            this.mVarsLoaded = true;
        }
    }

    void setSavedInternalData(SessionVariableSet savedSet) throws UserDBException {
        try {
            this.setSaveResult(savedSet.createSaveResult());
            this.setDirty(false);
        }
        catch (PersistenceManagerException e) {
            throw new UserDBException("userdb.ERR_SAVE_SESSION", (Throwable)e);
        }
    }

    void setSessionID(SessionID sessionID) {
        this.mSessionID = sessionID;
    }

    SessionID getSessionID() {
        return this.mSessionID;
    }

    SessionVariableSet encrypt(char[] key) throws UserDBException {
        if (this.isEncrypted()) {
            throw new IllegalStateException();
        }
        if (this.hasSecure()) {
            if (key == null) {
                throw new UserDBException("userdb.NO_PASSWORD_FOR_ENCRYPTION");
            }
            SessionVariableSet secure = this.cryptTransform(new CipherServices(key, true));
            secure.setEncrypted(true);
            return secure;
        }
        return (SessionVariableSet)this.clone();
    }

    SessionVariableSet decrypt(char[] key) throws SessionVarDecryptionException {
        SessionVariableSet sessionVariableSet;
        if (this.hasSecure()) {
            SessionVariableSet set;
            if (key == null) {
                throw new SessionVarDecryptionException();
            }
            if (this.getVars().isEmpty() || this.getVars().size() == 1 && this.canDetectPasswdChange()) {
                set = (SessionVariableSet)this.clone();
                set.remove(DETECT_PASSWD_CHANGE);
            } else {
                try {
                    set = this.cryptTransform(new CipherServices(key, false));
                }
                catch (UserDBException e) {
                    throw new SessionVarDecryptionException(e);
                }
            }
            set.setDirty(this.isDirty());
            if (set.isPasswdChange()) {
                throw new SessionVarDecryptionException();
            }
        } else {
            sessionVariableSet = (SessionVariableSet)this.clone();
        }
        return sessionVariableSet;
    }

    private SessionVariableSet cryptTransform(CipherServices cipher) throws UserDBException {
        Iterator iter = this.getVars().values().iterator();
        SessionVariableSet returnValue = (SessionVariableSet)this.clone();
        while (iter.hasNext()) {
            SessionVariable var = (SessionVariable)iter.next();
            if (!var.getSecure()) continue;
            returnValue.add(SessionVariable.createNoValidation(var.getName(), cipher.process(var.getValue()), var.getSecure()));
        }
        return returnValue;
    }

    public SessionVariableSet purgeNonDescriptorVars() throws PersistenceManagerException, RPCException {
        SessionVariableSet set = (SessionVariableSet)this.clone();
        MultiSessionVarDescriptorQuery query = MultiSessionVarDescriptorQuery.all();
        SummarySessionVarDescriptor[] descriptors = query.selectSummaryView();
        Vector<String> varNames = new Vector<String>();
        for (int i = 0; i < descriptors.length; ++i) {
            varNames.add(descriptors[i].getName());
        }
        HashSet actualSet = new HashSet(set.getVarNames());
        actualSet.removeAll(varNames);
        actualSet.remove(DETECT_PASSWD_CHANGE);
        Iterator iter = actualSet.iterator();
        while (iter.hasNext()) {
            set.remove((String)iter.next());
        }
        return set;
    }

    void ensureCanDetectPasswdChange() {
        if (!this.canDetectPasswdChange()) {
            this.add(SessionVariable.createNoValidation(DETECT_PASSWD_CHANGE, DETECT_PASSWD_CHANGE_VALUE, true));
        }
    }

    boolean canDetectPasswdChange() {
        return this.getVars().containsKey(DETECT_PASSWD_CHANGE);
    }

    private boolean isPasswdChange() {
        SessionVariable var;
        if (this.canDetectPasswdChange() && (var = (SessionVariable)this.getVars().get(DETECT_PASSWD_CHANGE)) != null) {
            return !ObjectUtil.equals(DETECT_PASSWD_CHANGE_VALUE, var.getValue());
        }
        return false;
    }

    private Hashtable getVars() {
        return this.mVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getModifiableVars() {
        if (!this.mIsVarTableCopy) {
            SessionVariableSet sessionVariableSet = this;
            synchronized (sessionVariableSet) {
                if (!this.mIsVarTableCopy) {
                    this.mVars = (Hashtable)this.mVars.clone();
                    this.mIsVarTableCopy = true;
                }
            }
        }
        this.setDirty(true);
        return this.mVars;
    }

    public String toString() {
        return "SessionVariableSet:UserID:" + this.mUserID + ":VarTable:" + this.mVars + ":IsCopy:" + this.mIsVarTableCopy + ":mIsDirty:" + this.mIsDirty + ":id:" + this.getObjectID() + ":updCnt:" + this.getUpdateCount();
    }

    private SessionVariableSet() {
    }

    SessionVariableSet(UserID userID) {
        if (userID == null) {
            throw new NullPointerException();
        }
        this.mUserID = userID;
    }

    public Object clone() {
        SessionVariableSet clone = null;
        try {
            clone = (SessionVariableSet)super.clone();
            clone.mIsVarTableCopy = false;
            this.mIsVarTableCopy = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private boolean isEncrypted() {
        return this.mIsEncrypted;
    }

    private void setEncrypted(boolean encrypted) {
        this.mIsEncrypted = encrypted;
    }

    static /* synthetic */ void access$200(SessionVariableSet x0, boolean x1) throws PersistenceManagerException {
        x0.trSaveMS(x1);
    }

    static class SessionVariableSetID
    extends ObjectID {
        private static final IDFactory ID_FACTORY = new IDFactory();

        SessionVariableSetID(String id) {
            super(id);
        }

        public static SessionVariableSetID generateID() {
            return (SessionVariableSetID)ID_FACTORY.generateObjectID();
        }

        static class IDFactory
        extends ObjectIDFactory {
            IDFactory() {
            }

            protected ObjectID newInstance(String inID) {
                return new SessionVariableSetID(inID);
            }
        }
    }
}

