/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.util.Validate;

public class SessionVariable
implements RPCSerializable {
    private String mName;
    private String mValue = "";
    private boolean mSecure = true;

    public SessionVariable(String name, String value, boolean isSecure) throws UserDBException {
        this.setName(name);
        this.setValue(value);
        this.setSecure(isSecure);
    }

    public String getName() {
        return this.mName;
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean getSecure() {
        return this.mSecure;
    }

    static SessionVariable createNoValidation(String name, String value, boolean isSecure) {
        SessionVariable var = new SessionVariable();
        var.mName = name;
        var.mValue = value;
        var.mSecure = isSecure;
        return var;
    }

    SessionVariable() {
    }

    SessionVariable(String name) throws UserDBException {
        this.setName(name);
    }

    private void setName(String name) throws UserDBException {
        if (!SessionVariable.isValidVarName(name)) {
            throw new UserDBException("userdb.INVALID_SESSION_VAR_NAME", name);
        }
        this.mName = name;
    }

    public String toString() {
        return "SessionVariable:Name:" + this.mName + ":isSecure:" + this.mSecure;
    }

    private void setValue(String value) throws UserDBException {
        if (!Validate.isValidObjectDescription(value)) {
            throw new UserDBException("userdb.INVALID_SESSION_VAR_VALUE", value);
        }
        this.mValue = value;
    }

    private void setSecure(boolean secure) {
        this.mSecure = secure;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SessionVariable)) {
            return false;
        }
        SessionVariable var = (SessionVariable)obj;
        return this.getName().equals(var.getName()) && this.getValue().equals(var.getValue()) && this.getSecure() == var.getSecure();
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getValue().hashCode();
    }

    public static boolean isValidVarName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0 || name.length() > 32) {
            return false;
        }
        if (!Validate.isValidFirstCharForName(name.charAt(0))) {
            return false;
        }
        return SessionVariable.hasValidNameChars(name);
    }

    private static boolean hasValidNameChars(String inString) {
        if (inString == null) {
            return false;
        }
        String validchars = "-_.";
        for (int i = 0; i < inString.length(); ++i) {
            char ch = inString.charAt(i);
            if (Character.isDigit(ch) || Character.isLetter(ch) || "-_.".indexOf(ch) != -1) continue;
            return false;
        }
        return true;
    }
}

