/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarImplTable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

class SessionVarImplSQLOps
extends SessionVarImplTable {
    public static final SessionVarImplSQLOps DEFAULT = new SessionVarImplSQLOps();

    public SessionVarImplSQLOps(String alias) {
        super(alias);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new SessionVarImplSQLOps(alias);
    }

    void deleteSet(SessionVariableSet.SessionVariableSetID inSetID) throws PersistenceManagerException {
        SessionVarImplSQLOps.execute(this.delete(SessionVarImplSQLOps.where(SessionVarImplSQLOps.equals(this.VarSetID, inSetID))));
    }

    void insertVars(SessionVariableSet.SessionVariableSetID setID, SessionVariable[] inVars) throws PersistenceManagerException {
        if (inVars == null || inVars.length == 0) {
            return;
        }
        Select varValues = null;
        for (int i = 0; i < inVars.length; ++i) {
            SessionVariable var = inVars[i];
            varValues = SessionVarImplSQLOps.anonSelect(SessionVarImplSQLOps.sList(SessionVarImplSQLOps.v(setID), SessionVarImplSQLOps.v(var.getName()), SessionVarImplSQLOps.v(var.getValue()), SessionVarImplSQLOps.v(var.getSecure())), varValues);
        }
        SessionVarImplSQLOps.execute(this.insert(SessionVarImplSQLOps.cList(this.VarSetID, this.Name, this.Value, this.Secure), varValues));
    }

    public SessionVariable[] selectVars(ObjectID inSetID) throws PersistenceManagerException {
        final Vector vars = new Vector();
        SessionVarImplSQLOps.execute(this.select(SessionVarImplSQLOps.sList(this.Name, this.Value, this.Secure), SessionVarImplSQLOps.where(SessionVarImplSQLOps.equals(this.VarSetID, inSetID))), new ResultSetProcessor(){

            public void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
                while (inResultSet.next()) {
                    String name = SessionVarImplSQLOps.this.Name.retrieveValue(inResultSet);
                    String value = SessionVarImplSQLOps.this.Value.retrieveValue(inResultSet);
                    boolean secure = SessionVarImplSQLOps.this.Secure.retrieveValue(inResultSet);
                    SessionVariable var = SessionVariable.createNoValidation(name, value, secure);
                    vars.add(var);
                }
            }
        });
        return vars.toArray(new SessionVariable[vars.size()]);
    }

    void deleteVarsNamed(Select varName) throws PersistenceManagerException {
        SessionVarImplSQLOps.execute(this.delete(SessionVarImplSQLOps.where(this.matchesName(varName))));
    }

    void deleteForUser(UserID id) throws PersistenceManagerException {
        SessionVarImplSQLOps.execute(this.delete(SessionVarImplSQLOps.where(SessionVarImplSQLOps.in((ColumnNode)this.VarSetID, SessionVariableSetSQLOps.DEFAULT.selectIDForUserID(id)))));
    }

    ConditionalExpression matchesName(Select varName) {
        return SessionVarImplSQLOps.in((ColumnNode)this.Name, varName);
    }

    private SessionVarImplSQLOps() {
        this(null);
    }
}

