/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptorID;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;

class SessionVarDescriptorImpl
extends PersistentBean
implements Cloneable {
    private String mName;
    private String mDescription = "";
    private boolean mSecure;
    private transient SummarySessionVarDescriptor mSummaryView;

    SessionVarDescriptorImpl(String name) {
        this.setName(name);
    }

    SessionVarDescriptorID getID() {
        return (SessionVarDescriptorID)super.getObjectID();
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int count) {
        super.setUpdateCount(count);
    }

    String getName() {
        return this.mName;
    }

    void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException();
        }
        this.mDescription = description;
    }

    boolean getSecure() {
        return this.mSecure;
    }

    void setSecure(boolean secure) {
        this.mSecure = secure;
    }

    void save() throws RPCException, PersistenceManagerException, UserDBException {
        this.validate();
        super.saveRPC(null);
    }

    void validate() throws UserDBException {
        SessionVarDescriptor.validateName(this.getName());
        SessionVarDescriptor.validateDescription(this.getDescription());
    }

    SummarySessionVarDescriptor getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummarySessionVarDescriptor(this);
        }
        return this.mSummaryView;
    }

    protected Object getObjectDataClone() {
        try {
            SessionVarDescriptorImpl impl = (SessionVarDescriptorImpl)super.getObjectDataClone();
            return impl;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object clone() {
        try {
            SessionVarDescriptorImpl impl = (SessionVarDescriptorImpl)super.clone();
            impl.mSummaryView = null;
            return impl;
        }
        catch (CloneNotSupportedException e) {
            return new InternalError();
        }
    }

    public String toString() {
        return "Name:" + this.mName + ":Description:" + this.mDescription + ":Secure:" + this.mSecure + ":ID:" + this.getID() + "UpdCnt:" + this.getUpdateCount();
    }

    private SessionVarDescriptorImpl() {
    }
}

