/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptorImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.util.Validate;

public class SessionVarDescriptor
extends SummarySessionVarDescriptor {
    private boolean mIsCopy = false;

    public SessionVarDescriptor(String name) {
        this.setVarImpl(new SessionVarDescriptorImpl(name));
        this.mIsCopy = true;
    }

    public void setName(String name) {
        this.getMutableVarImpl().setName(name);
    }

    public void setDescription(String description) {
        this.getMutableVarImpl().setDescription(description);
    }

    public void setSecure(boolean secure) {
        this.getMutableVarImpl().setSecure(secure);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableVarImpl().setUpdateCount(updateCount);
    }

    public SessionVarDescriptor getDataClone() {
        return new SessionVarDescriptor((SessionVarDescriptorImpl)this.getVarImpl().getObjectDataClone());
    }

    public void validate() throws UserDBException {
        this.getVarImpl().validate();
    }

    public void save() throws RPCException, PersistenceManagerException, UserDBException {
        this.getMutableVarImpl().save();
        this.mIsCopy = false;
    }

    public static void validateName(String name) throws UserDBException {
        if (!SessionVariable.isValidVarName(name)) {
            throw new UserDBException("userdb.INVALID_SESSION_VAR_NAME", name);
        }
    }

    public static void validateDescription(String description) throws UserDBException {
        if (!Validate.isValidObjectDescription(description)) {
            throw new UserDBException("userdb.INVALID_SESSION_VAR_DESC", description);
        }
    }

    SessionVarDescriptor(SessionVarDescriptorImpl inVarImpl) {
        super(inVarImpl);
    }

    private SessionVarDescriptor() {
    }

    private SessionVarDescriptorImpl getMutableVarImpl() {
        if (!this.mIsCopy) {
            this.setVarImpl((SessionVarDescriptorImpl)this.getVarImpl().clone());
            this.mIsCopy = true;
        }
        return this.getVarImpl();
    }

    public String toString() {
        return "SessionVarDescriptor:" + this.getVarImpl() + ":IsCopy:" + this.mIsCopy;
    }
}

