/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.Context;
import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.rpc.ContextManager;
import com.raplix.rolloutexpress.net.rpc.ContextValidator;
import com.raplix.rolloutexpress.net.rpc.InvalidContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.Session;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.ContextThread;
import com.raplix.util.threads.RunnableContext;
import com.raplix.util.threads.SafeThread;
import java.util.HashMap;
import java.util.Iterator;

public class SessionTable {
    private static final String MSG_SESSION_EXPIRED = "userdb.st.SESSION_EXPIRED";
    private HashMap mSessions = new HashMap();
    private SessionReaperThread mReaperThread;
    private long mSessionTimeout;
    private ContextManager mContextManager;

    SessionTable(ContextManager contextManager, long sessionTimeout, long reaperInterval) throws ContextException {
        contextManager.registerValidator(new SessionContextValidator());
        this.setContextManager(contextManager);
        this.setSessionTimeout(sessionTimeout);
        this.startSessionReaperThread(new SessionReaperThread(reaperInterval));
    }

    private void startSessionReaperThread(SessionReaperThread reaperThread) {
        this.mReaperThread = reaperThread;
        reaperThread.start();
    }

    void shutdown() {
        this.mReaperThread.shutdown();
    }

    long getSessionTimeout() {
        return this.mSessionTimeout;
    }

    private void setSessionTimeout(long sessionTimeout) {
        this.mSessionTimeout = sessionTimeout;
    }

    private ContextManager getContextManager() {
        return this.mContextManager;
    }

    private void setContextManager(ContextManager contextManager) {
        this.mContextManager = contextManager;
    }

    public Session getCurrentSession() {
        return this.getSession(this.getCurrentSessionID());
    }

    private SessionID getCurrentSessionID() {
        SessionID result = this.getSessionID(this.getContextManager().getContext());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("resolved session ID: " + result, this);
        }
        return result;
    }

    private SessionID getSessionID(Context ctx) {
        return ctx == null ? null : ctx.getData();
    }

    public Thread createThreadForCurrentSession(final Runnable runner, String threadName) {
        return new SafeThread(new Runnable(){

            public void run() {
                SessionTable.this.runWithCurrentSession(runner);
            }
        }, threadName);
    }

    public ContextThread createThreadForCurrentSession(RunnableContext runner) {
        return new ContextThread(runner){

            public void run() {
                SessionTable.this.runWithCurrentSession(this.getContext());
            }
        };
    }

    public void runWithCurrentSession(Runnable runner) {
        this.runWithSession(runner, this.getCurrentSessionID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithSession(Runnable runner, SessionID sessionID) {
        block12: {
            SessionTable sessionTable;
            Session session = null;
            SessionTable sessionTable2 = this;
            synchronized (sessionTable2) {
                session = this.lookupSession(sessionID);
                if (session != null) {
                    session.addRunner();
                }
            }
            try {
                runner.run();
                Object var7_6 = null;
                if (session == null) break block12;
                sessionTable = this;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (session != null) {
                    SessionTable sessionTable3 = this;
                    synchronized (sessionTable3) {
                        session.removeRunner();
                        this.reapIfZombie(session);
                    }
                }
                throw throwable;
            }
            synchronized (sessionTable) {
                session.removeRunner();
                this.reapIfZombie(session);
            }
        }
    }

    public synchronized Session getSession(SessionID sessionID) {
        return this.lookupSession(sessionID);
    }

    private Session lookupSession(SessionID sessionID) {
        return this.reapIfZombie((Session)this.mSessions.get(sessionID));
    }

    SessionID createSession(UserID userID, SessionVariableSet inSet) throws RPCException {
        Session session = new Session(userID, this.getSessionTimeout(), inSet);
        this.addSessionToMap(session);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("session " + session.getSessionID() + " created for user " + userID, this);
        }
        return session.getSessionID();
    }

    private synchronized void addSessionToMap(Session session) {
        this.mSessions.put(session.getSessionID(), session);
    }

    Session removeCurrentSession() {
        return this.removeSession(this.getCurrentSessionID());
    }

    synchronized Session removeSession(SessionID sessionID) {
        Session session;
        if (sessionID == null) {
            return null;
        }
        Session result = session = (Session)this.mSessions.get(sessionID);
        if (session != null) {
            if (!session.isActive(false)) {
                result = null;
            }
            session.deactivate();
            this.reapIfZombie(session);
        }
        return result;
    }

    private synchronized void validateSession(SessionID sessionID) throws InvalidContext {
        if (sessionID == null) {
            return;
        }
        Session session = (Session)this.mSessions.get(sessionID);
        if (session != null && session.isActive(true)) {
            return;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("requested session expired: " + sessionID, this);
        }
        this.reapIfZombie(session);
        throw new InvalidContext(MSG_SESSION_EXPIRED, new Object[]{sessionID});
    }

    private Session reapIfZombie(Session session) {
        if (session != null && session.isZombie()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("reaping expired session: " + session, this);
            }
            this.mSessions.remove(session.getSessionID());
            session = null;
        }
        return session;
    }

    private synchronized void reapSessions() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("searching for expired sessions", this);
        }
        Iterator sessions = this.mSessions.values().iterator();
        while (sessions.hasNext()) {
            Session session = (Session)sessions.next();
            if (!session.isZombie()) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("reaping expired session: " + session, this);
            }
            sessions.remove();
        }
    }

    private class SessionContextValidator
    implements ContextValidator {
        private SessionContextValidator() {
        }

        public void validate(Context ctx) throws InvalidContext {
            SessionTable.this.validateSession(SessionTable.this.getSessionID(ctx));
        }
    }

    private class SessionReaperThread
    extends SafeThread {
        private static final String THREAD_NAME = "SessionReaperThread";
        private volatile boolean mRunning;
        private long mSleepTime;

        SessionReaperThread(long sleepTime) {
            super(THREAD_NAME);
            this.setSleepTime(sleepTime);
            this.mRunning = true;
        }

        private long getSleepTime() {
            return this.mSleepTime;
        }

        private void setSleepTime(long sleepTime) {
            this.mSleepTime = sleepTime;
        }

        public void run() {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Thread SessionReaperThread started", this);
            }
            while (true) {
                try {
                    SessionReaperThread.sleep(this.getSleepTime());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.mRunning) break;
                SessionTable.this.reapSessions();
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Thread SessionReaperThread done", this);
            }
        }

        void shutdown() {
            this.mRunning = false;
            this.interruptSafe();
        }
    }
}

