/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.event.ROXUserEvent;
import com.raplix.rolloutexpress.event.ROXUserLoginEvent;
import com.raplix.rolloutexpress.event.ROXUserLoginFailedEvent;
import com.raplix.rolloutexpress.event.ROXUserLogoutEvent;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.userdb.AuthenticationException;
import com.raplix.rolloutexpress.systemmodel.userdb.Authenticator;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.Session;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionListener;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDecryptionException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarImplSQLOps;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.userdb.SingleSessionVariableSetQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SessionManagerServiceImpl
implements SessionManagerService {
    private TransactionManager mTransactionManager;
    private Authenticator mAuthenticator;
    private SessionTable mSessionTable;
    private boolean mPersistVars;
    private UserDBSubsystem mUserDBSubsystem;
    private SessionListener mSessionListener;

    SessionManagerServiceImpl(UserDBSubsystem userDBSubsystem, Authenticator authenticator, SessionTable sessionTable, SessionListener listener, PersistenceManager inPM) throws ConfigurationException {
        this.setUserDBSubsystem(userDBSubsystem);
        this.setAuthenticator(authenticator);
        this.setSessionTable(sessionTable);
        this.setSessionListener(listener);
        this.setPersistVars(userDBSubsystem.getConfigSessionVariablePersist());
        this.setTransactionManager(inPM.getTransactionManager());
    }

    private void setTransactionManager(TransactionManager inTransactionManager) {
        this.mTransactionManager = inTransactionManager;
    }

    private Authenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    private void setAuthenticator(Authenticator authenticator) {
        this.mAuthenticator = authenticator;
    }

    private SessionTable getSessionTable() {
        return this.mSessionTable;
    }

    private void setSessionTable(SessionTable sessionTable) {
        this.mSessionTable = sessionTable;
    }

    private boolean getPersistVars() {
        return this.mPersistVars;
    }

    private void setPersistVars(boolean persistVars) {
        this.mPersistVars = persistVars;
    }

    private void setUserDBSubsystem(UserDBSubsystem inUserDBSubsystem) {
        this.mUserDBSubsystem = inUserDBSubsystem;
    }

    public SessionID login(String username, String password) throws AuthenticationException, UserDBException, RPCException {
        try {
            this.doLogout();
            UserID userID = this.getAuthenticator().authenticate(username, password);
            SessionVariableSet currentSet = null;
            try {
                try {
                    currentSet = SingleSessionVariableSetQuery.byUserID(userID).select();
                }
                catch (NoResultsFoundException ignored) {
                    currentSet = new SessionVariableSet(userID);
                }
            }
            catch (PersistenceManagerException pe) {
                throw new UserDBException("userdb.ERR_RETRIEVE_SESSION_VARS", (Throwable)pe);
            }
            if (currentSet.hasSecure()) {
                currentSet = currentSet.decrypt(password != null ? password.toCharArray() : null);
            }
            SessionID result = this.getSessionTable().createSession(userID, currentSet);
            this.userLoggedIn(userID);
            return result;
        }
        catch (AuthenticationException e) {
            this.userLoginFailed(username, e);
            throw e;
        }
    }

    public UserID getCurrentUserID() {
        Session session = this.getSessionTable().getCurrentSession();
        if (session != null) {
            return session.getUserID();
        }
        return null;
    }

    public SessionID getCurrentSessionID() {
        Session session = this.getSessionTable().getCurrentSession();
        if (session != null) {
            return session.getSessionID();
        }
        return null;
    }

    public boolean logout() {
        boolean result = this.doLogout();
        if (!result && Logger.isWarnEnabled(this)) {
            Logger.warn("logout attempted with no active session", this);
        }
        return result;
    }

    private boolean doLogout() {
        Session session = this.getSessionTable().removeCurrentSession();
        if (session != null) {
            this.userLoggedOut(session.getUserID());
            return true;
        }
        return false;
    }

    private SessionListener getSessionListener() {
        return this.mSessionListener;
    }

    private void setSessionListener(SessionListener sessionListener) {
        this.mSessionListener = sessionListener;
    }

    public void autheticate(String username, String password) throws AuthenticationException, RPCException {
        this.getAuthenticator().authenticate(username, password);
    }

    private void userLoggedIn(UserID user) {
        ROXUserLoginEvent event = ROXUserEvent.login(user);
        this.getSessionListener().userLoggedIn(event);
    }

    private void userLoginFailed(String username, AuthenticationException e) {
        ROXUserLoginFailedEvent event = ROXUserEvent.loginFailed(username, (CommandException)e);
        this.getSessionListener().userLoginFailed(event);
    }

    private void userLoggedOut(UserID user) {
        ROXUserLogoutEvent event = ROXUserEvent.logout(user);
        this.getSessionListener().userLoggedOut(event);
    }

    public long getSessionTimeout() {
        return this.mSessionTable.getSessionTimeout();
    }

    public SessionVariableSet getSessionVariables() throws UserDBException, RPCException {
        Session session = this.getSessionTable().getCurrentSession();
        if (session == null) {
            return null;
        }
        return session.getVariableSet();
    }

    public void setSessionVariables(SessionVariableSet inSet) throws UserDBException, RPCException {
        Session session = this.getSessionTable().getCurrentSession();
        if (session == null && inSet.getSessionID() != null) {
            session = this.getSessionTable().getSession(inSet.getSessionID());
        }
        if (session == null || !session.getUserID().equals(inSet.getUserID())) {
            throw new UserDBException("userdb.INVALID_SESSION_REQUEST");
        }
        session.setVariableSet(inSet);
    }

    public void saveSessionVariables(SessionVariableSet inSecureSet) throws UserDBException, RPCException {
        if (!this.getPersistVars()) {
            throw new UserDBException("userdb.SESSION_VARS_NOT_PERSISTENT");
        }
        Session session = this.getSessionTable().getCurrentSession();
        if (session == null || !session.getUserID().equals(inSecureSet.getUserID())) {
            throw new UserDBException("userdb.INVALID_SESSION_REQUEST");
        }
        inSecureSet.saveMS();
        session.setVariableSetSaved(inSecureSet);
    }

    public LoginConfiguration[] getLoginConfigurations() {
        return this.mUserDBSubsystem.getAuthModules();
    }

    public void recryptSessionVariables(final boolean clearVariables, String username, final String newPassword, final String originalPassword) throws UserDBException, RPCException {
        UserID userID;
        if (!clearVariables && (originalPassword == null || originalPassword.length() == 0) || newPassword == null || newPassword.length() == 0) {
            throw new UserDBException("userdb.usi.PWD_NOT_SPECIFIED_FOR_RECRYPT", new Integer(clearVariables ? 0 : 1));
        }
        try {
            userID = this.getAuthenticator().authenticate(username, newPassword);
        }
        catch (AuthenticationException authException) {
            throw new UserDBException("userdb.ERR_RECRYPT_SESSION_VARS", authException.getCause(), new Integer(clearVariables ? 0 : 1));
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UserDBException, RPCException {
                    SessionManagerServiceImpl.this.privilegedRecrypt(clearVariables, userID, originalPassword, newPassword);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof UserDBException) {
                throw (UserDBException)e.getCause();
            }
            if (e.getCause() instanceof RPCException) {
                throw (RPCException)e.getCause();
            }
            throw new UserDBException(e.getCause());
        }
    }

    private void privilegedRecrypt(boolean clearVariables, final UserID inUserID, String originalPassword, String newPassword) throws RPCException, UserDBException {
        block7: {
            try {
                if (clearVariables) {
                    this.transact(new Transaction(){

                        public Object execute() throws PersistenceManagerException {
                            SessionVarImplSQLOps.DEFAULT.deleteForUser(inUserID);
                            SessionVariableSetSQLOps.DEFAULT.delete(inUserID);
                            return null;
                        }
                    });
                    break block7;
                }
                SessionVariableSet currentSet = null;
                try {
                    currentSet = SingleSessionVariableSetQuery.byUserID(inUserID).select();
                }
                catch (NoResultsFoundException ignored) {
                    // empty catch block
                }
                if (currentSet != null) {
                    currentSet = currentSet.decrypt(originalPassword == null ? null : originalPassword.toCharArray());
                    currentSet.ensureCanDetectPasswdChange();
                    currentSet = currentSet.encrypt(newPassword.toCharArray());
                    currentSet.saveMS();
                }
            }
            catch (PersistenceManagerException pe) {
                throw new UserDBException("userdb.ERR_RECRYPT_SESSION_VARS", pe.getCause(), new Integer(clearVariables ? 0 : 1));
            }
            catch (SessionVarDecryptionException e) {
                throw new UserDBException("userdb.ERR_RECRYPT_SESSION_VARS", e.getCause(), new Integer(clearVariables ? 0 : 1));
            }
        }
    }

    private void transact(Transaction inTransaction) throws PersistenceManagerException {
        this.mTransactionManager.transact(inTransaction);
    }
}

