/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXUserLoginEvent;
import com.raplix.rolloutexpress.event.ROXUserLoginFailedEvent;
import com.raplix.rolloutexpress.event.ROXUserLogoutEvent;
import com.raplix.util.logger.Logger;
import java.util.EventListener;

public interface SessionListener
extends EventListener {
    public void userLoggedIn(ROXUserLoginEvent var1);

    public void userLoginFailed(ROXUserLoginFailedEvent var1);

    public void userLoggedOut(ROXUserLogoutEvent var1);

    public static class LogWriter
    implements SessionListener {
        public void userLoggedIn(ROXUserLoginEvent event) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("user logged in: " + event, this);
            }
        }

        public void userLoginFailed(ROXUserLoginFailedEvent event) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("user login failed: " + event, this);
            }
        }

        public void userLoggedOut(ROXUserLogoutEvent event) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("user logged out: " + event, this);
            }
        }
    }

    public static class Notifier
    implements SessionListener {
        private NotificationManager mNotificationManager;

        public Notifier(NotificationManager nm) {
            this.setNotificationManager(nm);
        }

        public void userLoggedIn(ROXUserLoginEvent event) {
            this.getNotificationManager().notify(event);
        }

        public void userLoginFailed(ROXUserLoginFailedEvent event) {
            this.getNotificationManager().notify(event);
        }

        public void userLoggedOut(ROXUserLogoutEvent event) {
            this.getNotificationManager().notify(event);
        }

        private NotificationManager getNotificationManager() {
            return this.mNotificationManager;
        }

        private void setNotificationManager(NotificationManager notificationManager) {
            this.mNotificationManager = notificationManager;
        }
    }
}

