/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

public class Session {
    private SessionVariableSet mVariableSet;
    private UserID mUserID;
    private SessionID mSessionID;
    private long mSessionTimeout;
    private boolean mIsActive = true;
    private long mLastTouched;
    private int mRunners = 0;

    Session(UserID userID, long sessionTimeout, SessionVariableSet currentSet) {
        this.setUserID(userID);
        this.setSessionTimeout(sessionTimeout);
        this.setSessionID(SessionID.generateSessionID());
        currentSet.setSessionID(this.getSessionID());
        this.setVariableSet(currentSet);
        this.mIsActive = true;
        this.mLastTouched = System.currentTimeMillis();
    }

    public UserID getUserID() {
        return this.mUserID;
    }

    private void setUserID(UserID userID) {
        this.mUserID = userID;
    }

    public SessionID getSessionID() {
        return this.mSessionID;
    }

    private void setSessionID(SessionID sessionID) {
        this.mSessionID = sessionID;
    }

    private long getSessionTimeout() {
        return this.mSessionTimeout;
    }

    private void setSessionTimeout(long sessionTimeout) {
        this.mSessionTimeout = sessionTimeout;
    }

    public SessionVariableSet getVariableSet() {
        return (SessionVariableSet)this.mVariableSet.clone();
    }

    void setVariableSet(SessionVariableSet variableSet) {
        if (variableSet == null) {
            throw new NullPointerException();
        }
        if (!this.getSessionID().equals(variableSet.getSessionID())) {
            throw new IllegalArgumentException();
        }
        this.mVariableSet = (SessionVariableSet)variableSet.clone();
    }

    void setVariableSetSaved(SessionVariableSet savedVariableSet) throws UserDBException {
        this.mVariableSet.setSavedInternalData(savedVariableSet);
    }

    synchronized void deactivate() {
        this.mIsActive = false;
    }

    public synchronized boolean isActive(boolean touch) {
        if (!this.mIsActive) {
            return false;
        }
        long lastTouched = this.mLastTouched;
        long currentTime = System.currentTimeMillis();
        long inactiveTime = currentTime - lastTouched;
        if (inactiveTime > this.getSessionTimeout()) {
            this.mIsActive = false;
        } else if (touch) {
            this.mLastTouched = currentTime;
        }
        return this.mIsActive;
    }

    synchronized void addRunner() {
        ++this.mRunners;
    }

    synchronized void removeRunner() {
        --this.mRunners;
    }

    synchronized boolean isZombie() {
        return this.mRunners == 0 && !this.isActive(false);
    }

    public String toString() {
        return "Session{SessionID:" + this.getSessionID() + ",UserID:" + this.getUserID() + "}";
    }
}

