/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteObject;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUser;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.UserServicesImpl;

class RemoteUserManager
implements UserManager {
    private static final String MSG_DELETE_NULL_USERID = "userdb.ru.DELETE_NULL_USERID";
    private RemoteUserDBAdmin m_remoteAdmin;
    private UserManagerService mUserManagerService;
    public static final UserID ADMIN_USERID = new UserID("010010001024-0000000000000-00001-0000000001");

    RemoteUserManager(RemoteUserDBAdmin remoteAdmin) {
        this.setRemoteAdmin(remoteAdmin);
    }

    private RemoteUserDBAdmin getRemoteAdmin() {
        return this.m_remoteAdmin;
    }

    private void setRemoteAdmin(RemoteUserDBAdmin remoteAdmin) {
        this.m_remoteAdmin = remoteAdmin;
        this.setUserManagerService(remoteAdmin.getUserManagerService());
    }

    private UserManagerService getUserManagerService() {
        return this.mUserManagerService;
    }

    private void setUserManagerService(UserManagerService userManagerService) {
        this.mUserManagerService = userManagerService;
    }

    public User newUser(String username) {
        return new RemoteUser(this.getRemoteAdmin(), username);
    }

    public User getUser(UserID userID) throws UserDBException, RPCException {
        return new RemoteUser(this.getRemoteAdmin(), userID, this.getUserManagerService().getUserData(userID));
    }

    public User getUser(String username) throws UserDBException, RPCException {
        RemoteUser result = this.getUserManagerService().getUser(username);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public void deleteUser(UserID userID) throws RPCException, UserDBException {
        if (userID == null) {
            throw new UserDBException(MSG_DELETE_NULL_USERID);
        }
        this.getUserManagerService().delete(userID);
    }

    public User[] getAllUsers() throws UserDBException, RPCException {
        RemoteObject[] result = this.getUserManagerService().getAllUsers();
        this.getRemoteAdmin().register(result);
        return result;
    }

    public void changePassword(String username, String origPwd, String newPwd) throws UserDBException, RPCException {
        UserServicesImpl.validatePassword(newPwd);
        this.getUserManagerService().changePassword(username, origPwd, newPwd);
    }

    public UserID getAdminUserID() {
        return ADMIN_USERID;
    }

    static boolean isSystemUser(UserID userID) {
        return ADMIN_USERID.equals(userID);
    }
}

