/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.systemmodel.userdb.DigestStringHasher;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteSessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.StringHasher;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import java.security.NoSuchAlgorithmException;

public class RemoteUserDBSubsystem
extends Subsystem {
    private static final String MSG_UNKNOWN_ALGORITHM = "userdb.UNKNOWN_ALGORITHM";
    private RPCManager mRPCManager;
    private StringHasher mStringHasher;

    RemoteUserDBSubsystem() {
    }

    public RemoteUserDBSubsystem(Application inApplication) throws ConfigurationException {
        super(inApplication);
        this.setRPCManager(inApplication.getNetSubsystem().getRPC());
        try {
            this.setStringHasher(new DigestStringHasher());
        }
        catch (NoSuchAlgorithmException e) {
            throw this.configError(MSG_UNKNOWN_ALGORITHM, e);
        }
    }

    protected ConfigurationException configError(String msgKey, Exception e) throws ConfigurationException {
        if (Logger.isDebugEnabled(this)) {
            String message = MessageManager.messageAsString(msgKey);
            Logger.debug(message, e, this);
        }
        return new ConfigurationException(msgKey, (Throwable)e);
    }

    protected RPCManager getRPCManager() {
        return this.mRPCManager;
    }

    private void setRPCManager(RPCManager RPCManager2) {
        this.mRPCManager = RPCManager2;
    }

    public UserDBAdmin getUserDBAdmin(RoxAddress addr) throws RPCException {
        return new RemoteUserDBAdmin(this.getRPCManager(), addr, this.getStringHasher(), this);
    }

    public SessionManager getSessionManager(RoxAddress addr) throws RPCException {
        return new RemoteSessionManager(this.getRPCManager(), addr);
    }

    private StringHasher getStringHasher() {
        return this.mStringHasher;
    }

    private void setStringHasher(StringHasher stringHasher) {
        this.mStringHasher = stringHasher;
    }

    public HashedString hash(String username, String password) throws UserDBException {
        if (password == null) {
            return null;
        }
        return this.getStringHasher().hash(username, password);
    }
}

