/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupService;
import com.raplix.rolloutexpress.systemmodel.userdb.HashException;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionService;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteObject;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.StringHasher;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.UserService;

class RemoteUserDBAdmin
implements UserDBAdmin {
    private StringHasher mStringHasher;
    private RemoteUserDBSubsystem mSubsystem;
    private GroupManager m_groupManager;
    private UserManager m_userManager;
    private PermissionManager m_permissionManager;
    private GroupManagerService m_groupManagerService;
    private GroupService m_groupService;
    private UserManagerService m_userManagerService;
    private UserService m_userService;
    private PermissionManagerService m_permissionManagerService;
    private PermissionService m_permissionService;
    private SessionManagerService m_sessionService;

    RemoteUserDBAdmin(RPCManager rpc, RoxAddress addr, StringHasher stringHasher, RemoteUserDBSubsystem inSubsystem) throws RPCException {
        this.setStringHasher(stringHasher);
        GroupManagerService groupManagerService = (GroupManagerService)rpc.getLocalService(addr, GroupManagerService.class);
        this.setGroupManagerService(groupManagerService);
        GroupService groupService = (GroupService)rpc.getLocalService(addr, GroupService.class);
        this.setGroupService(groupService);
        UserManagerService userManagerService = (UserManagerService)rpc.getLocalService(addr, UserManagerService.class);
        this.setUserManagerService(userManagerService);
        UserService userService = (UserService)rpc.getLocalService(addr, UserService.class);
        this.setUserService(userService);
        PermissionManagerService permissionManagerService = (PermissionManagerService)rpc.getLocalService(addr, PermissionManagerService.class);
        this.setPermissionManagerService(permissionManagerService);
        PermissionService permissionService = (PermissionService)rpc.getLocalService(addr, PermissionService.class);
        this.setPermissionService(permissionService);
        this.setGroupManager(new RemoteGroupManager(this));
        this.setUserManager(new RemoteUserManager(this));
        this.setPermissionManager(new RemotePermissionManager(this));
        this.mSubsystem = inSubsystem;
        try {
            this.initSessionServices(rpc, addr);
        }
        catch (RPCException ignored) {
            // empty catch block
        }
    }

    void initSessionServices(RPCManager rpc, RoxAddress addr) throws RPCException {
        SessionManagerService sessionService = (SessionManagerService)rpc.getLocalService(addr, SessionManagerService.class);
        this.setSessionManagerService(sessionService);
    }

    RemoteUserDBSubsystem getSubsystem() {
        return this.mSubsystem;
    }

    private StringHasher getStringHasher() {
        return this.mStringHasher;
    }

    private void setStringHasher(StringHasher stringHasher) {
        this.mStringHasher = stringHasher;
    }

    HashedString hash(String name, String string) throws HashException {
        return this.getStringHasher().hash(name, string);
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    private void setGroupManager(GroupManager groupManager) {
        this.m_groupManager = groupManager;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    private void setUserManager(UserManager userManager) {
        this.m_userManager = userManager;
    }

    public PermissionManager getPermissionManager() {
        return this.m_permissionManager;
    }

    private void setPermissionManager(PermissionManager permissionManager) {
        this.m_permissionManager = permissionManager;
    }

    public GroupManagerService getGroupManagerService() {
        return this.m_groupManagerService;
    }

    private void setGroupManagerService(GroupManagerService groupManagerService) {
        this.m_groupManagerService = groupManagerService;
    }

    public GroupService getGroupService() {
        return this.m_groupService;
    }

    private void setGroupService(GroupService groupService) {
        this.m_groupService = groupService;
    }

    public UserManagerService getUserManagerService() {
        return this.m_userManagerService;
    }

    private void setUserManagerService(UserManagerService userManagerService) {
        this.m_userManagerService = userManagerService;
    }

    public UserService getUserService() {
        return this.m_userService;
    }

    private void setUserService(UserService userService) {
        this.m_userService = userService;
    }

    public PermissionManagerService getPermissionManagerService() {
        return this.m_permissionManagerService;
    }

    private void setPermissionManagerService(PermissionManagerService permissionManagerService) {
        this.m_permissionManagerService = permissionManagerService;
    }

    public PermissionService getPermissionService() {
        return this.m_permissionService;
    }

    private void setPermissionService(PermissionService permissionService) {
        this.m_permissionService = permissionService;
    }

    public SessionManagerService getSessionManagerService() {
        return this.m_sessionService;
    }

    private void setSessionManagerService(SessionManagerService sessionService) {
        this.m_sessionService = sessionService;
    }

    void register(RemoteObject obj) {
        if (obj != null) {
            obj.setRemoteAdmin(this);
        }
    }

    void register(RemoteObject[] obj) {
        if (obj != null) {
            int len = obj.length;
            for (int i = 0; i < len; ++i) {
                this.register(obj[i]);
            }
        }
    }

    PermissionID[] toIDs(Permission[] permissions) {
        PermissionID[] result;
        if (permissions == null) {
            result = new PermissionID[]{};
        } else {
            result = new PermissionID[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                result[i] = permissions[i].getPermissionID();
            }
        }
        return result;
    }

    GroupID[] toIDs(Group[] groups) {
        GroupID[] result;
        if (groups == null) {
            result = new GroupID[]{};
        } else {
            result = new GroupID[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                result[i] = groups[i].getGroupID();
            }
        }
        return result;
    }

    UserID[] toIDs(User[] users) {
        UserID[] result;
        if (users == null) {
            result = new UserID[]{};
        } else {
            result = new UserID[users.length];
            for (int i = 0; i < users.length; ++i) {
                result[i] = users[i].getUserID();
            }
        }
        return result;
    }
}

