/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteObject;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserData;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserService;
import com.raplix.rolloutexpress.systemmodel.userdb.UserServicesImpl;

class RemoteUser
extends RemoteObject
implements User,
HasObjectID {
    private transient UserService m_userService;
    private UserID m_userID;
    private transient RemoteGroup[] m_groups;
    private transient boolean m_groupsIsDirty;
    private UserData m_userData = null;

    private RemoteUser() {
    }

    RemoteUser(RemoteUserDBAdmin remoteAdmin, String username) {
        super(remoteAdmin);
        this.setUserData(new UserData());
        this.getUserData().setUsername(username);
    }

    RemoteUser(RemoteUserDBAdmin remoteAdmin, UserID userID, UserData userData) {
        super(remoteAdmin);
        this.setUserID(userID);
        this.setUserData(userData);
    }

    RemoteUser(UserID userID, UserData userData) {
        this.setUserID(userID);
        this.setUserData(userData);
    }

    void setRemoteAdmin(RemoteUserDBAdmin remoteAdmin) {
        super.setRemoteAdmin(remoteAdmin);
        this.setUserService(remoteAdmin.getUserService());
    }

    private UserService getUserService() {
        return this.m_userService;
    }

    private void setUserService(UserService userService) {
        this.m_userService = userService;
    }

    public UserID getUserID() {
        return this.m_userID;
    }

    private void setUserID(UserID userID) {
        this.m_userID = userID;
    }

    public int getUpdateCount() {
        return this.getUserData().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getUserData().setUpdateCount(updateCount);
    }

    public String getUsername() {
        return this.getUserData().getUsername();
    }

    public void setPassword(String password) throws UserDBException {
        this.getUserData().setPassword(this.hash(password));
    }

    public HashedString getPassword() {
        return this.getUserData().getPassword();
    }

    private HashedString hash(String password) throws UserDBException {
        if (password == null) {
            return null;
        }
        UserServicesImpl.validatePassword(password);
        return this.getRemoteAdmin().hash(this.getUsername(), password);
    }

    public Group[] getGroups() throws RPCException, UserDBException {
        UserID id;
        if (this.m_groups == null && (id = this.getUserID()) != null) {
            RemoteObject[] groups = this.getUserService().getGroups(id);
            this.getRemoteAdmin().register(groups);
            this.m_groups = groups;
        }
        return this.m_groups;
    }

    public void setGroups(Group[] groups) {
        if (groups instanceof RemoteGroup[]) {
            this.m_groups = (RemoteGroup[])groups;
        } else {
            RemoteGroup[] remoteGroups = new RemoteGroup[groups.length];
            System.arraycopy(groups, 0, remoteGroups, 0, groups.length);
            this.m_groups = remoteGroups;
        }
        this.m_groupsIsDirty = true;
    }

    public void save(boolean forceClearVars) throws RPCException, UserDBException {
        UserID userID = this.getUserID();
        if (!this.getActive()) {
            UserID.validateForDeactivation(userID, this.getRemoteAdmin().getUserManager());
        }
        UserData userData = this.getUserData();
        GroupID[] groups = null;
        if (this.m_groupsIsDirty) {
            groups = this.getRemoteAdmin().toIDs(this.m_groups);
        }
        userID = this.getUserService().save(userID, userData, groups, forceClearVars);
        this.setUserID(userID);
        this.incrementUpdateCount();
        this.m_groupsIsDirty = false;
    }

    public boolean equals(Object other) {
        UserID thisUserID;
        if (other == this) {
            return true;
        }
        if (other != null && other instanceof User && (thisUserID = this.getUserID()) != null) {
            UserID otherUserID = ((User)other).getUserID();
            return thisUserID.equals(otherUserID);
        }
        return false;
    }

    public int hashCode() {
        UserID id = this.getUserID();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        UserID userID = this.getUserID();
        return "User:" + (userID != null ? userID.toString() : super.toString());
    }

    private UserData getUserData() {
        return this.m_userData;
    }

    private void setUserData(UserData userData) {
        this.m_userData = userData;
    }

    public void setVisibility(Visibility inVisibility) {
        this.m_userData.setVisibility(inVisibility);
    }

    public Visibility getVisibility() {
        return this.m_userData.getVisibility();
    }

    public boolean getActive() {
        return this.m_userData.getActive();
    }

    public void setActive(boolean inActive) {
        this.setVisibility(inActive ? Visibility.VISIBLE : Visibility.HIDDEN);
        this.m_userData.setActive(inActive);
    }

    public ObjectID getObjectID() {
        return this.getUserID();
    }

    public String getLoginConfiguration() {
        return this.m_userData.getLoginConfiguration();
    }

    public void setLoginConfiguration(String inConfiguration) {
        this.m_userData.setLoginConfiguration(inConfiguration);
    }

    public boolean isClearSessionVarsOnLoginConfigChange() {
        return this.m_userData.isClearSessionVarsOnLoginConfigChange();
    }
}

