/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.systemmodel.userdb.AuthenticationException;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManagerService;

class RemoteSessionManager
implements SessionManager {
    private SessionManagerService mService;
    private UserManagerService mUserService;

    RemoteSessionManager(RPCManager rpc, RoxAddress addr) throws RPCException {
        SessionManagerService sessionManagerService = (SessionManagerService)rpc.getLocalService(addr, SessionManagerService.class);
        this.setService(sessionManagerService);
        UserManagerService userManagerService = (UserManagerService)rpc.getLocalService(addr, UserManagerService.class);
        this.setUserService(userManagerService);
    }

    private SessionManagerService getService() {
        return this.mService;
    }

    private void setService(SessionManagerService service) {
        this.mService = service;
    }

    private UserManagerService getUserService() {
        return this.mUserService;
    }

    private void setUserService(UserManagerService service) {
        this.mUserService = service;
    }

    public SessionID login(String username, String password) throws UserDBException, RPCException {
        return this.getService().login(username, password);
    }

    public long getSessionTimeout() throws RPCException {
        return this.getService().getSessionTimeout();
    }

    public UserID getCurrentUserID() throws UserDBException, RPCException {
        return this.getService().getCurrentUserID();
    }

    public SessionID getCurrentSessionID() throws UserDBException, RPCException {
        return this.getService().getCurrentSessionID();
    }

    public boolean logout() throws UserDBException, RPCException {
        return this.getService().logout();
    }

    public SessionVariableSet getSessionVariables() throws UserDBException, RPCException {
        return this.getService().getSessionVariables();
    }

    public void setSessionVariables(SessionVariableSet inSet) throws UserDBException, RPCException {
        if (inSet == null) {
            throw new NullPointerException();
        }
        this.getService().setSessionVariables(inSet);
    }

    public void saveSessionVariables(String password) throws UserDBException, RPCException {
        this.validatePassword(password);
        SessionVariableSet variables = this.getSessionVariables();
        variables.remove("sys:detectpasschange", true);
        variables.ensureCanDetectPasswdChange();
        SessionVariableSet secure = variables.encrypt(password != null ? password.toCharArray() : null);
        this.getService().saveSessionVariables(secure);
    }

    public void validatePassword(String password) throws UserDBException, RPCException {
        if (password != null) {
            UserID userID = this.getService().getCurrentUserID();
            if (userID == null) {
                throw new UserDBException("userdb.INVALID_SESSION_REQUEST");
            }
            String username = this.getUserService().getUserData(userID).getUsername();
            try {
                this.getService().autheticate(username, password);
            }
            catch (AuthenticationException e) {
                throw new AuthenticationException("userdb.INVALID_PASSWORD", (Throwable)e);
            }
        }
    }

    public LoginConfiguration[] getLoginConfigurations() throws RPCException {
        return this.getService().getLoginConfigurations();
    }

    public void recryptSessionVariables(boolean clearVariables, String username, String newPassword, String originalPassword) throws UserDBException, RPCException {
        this.getService().recryptSessionVariables(clearVariables, username, newPassword, originalPassword);
    }
}

