/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionData;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteObject;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermission;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class RemotePermissionManager
implements PermissionManager {
    private static final String MSG_DELETE_NULL_PERMISSIONID = "userdb.rp.DELETE_NULL_PERMISSIONID";
    private RemoteUserDBAdmin m_remoteAdmin;
    private PermissionManagerService mPermissionManagerService;
    private static final Set EMPTY_SET = new HashSet();
    private static final HashMap sRegisteredGroups = new HashMap();
    private static final HashSet sSystemPermissions = new HashSet();
    private static final HashSet sVisiblePermissions = new HashSet();
    public static final PermissionID USERDB_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00001-0000000003", RemoteGroupManager.REGISTERED_GROUPID, true);
    public static final PermissionID USERDB_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00002-0000000003", RemoteGroupManager.ADMIN_GROUPID, true);
    public static final PermissionID HOST_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00003-0000000003", RemoteGroupManager.REGISTERED_GROUPID, true);
    public static final PermissionID HOST_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00004-0000000003", RemoteGroupManager.ADMIN_GROUPID, true);
    public static final PermissionID HOST_TYPE_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00005-0000000003", RemoteGroupManager.REGISTERED_GROUPID, true);
    public static final PermissionID HOST_TYPE_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00006-0000000003", RemoteGroupManager.ADMIN_GROUPID, true);
    public static final PermissionID RULE_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00007-0000000003", RemoteGroupManager.REGISTERED_GROUPID, true);
    public static final PermissionID RULE_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00008-0000000003", RemoteGroupManager.ADMIN_GROUPID, true);
    public static final PermissionID PLUGIN_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00027-0000000003", RemoteGroupManager.REGISTERED_GROUPID, false);
    public static final PermissionID PLUGIN_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00028-0000000003", RemoteGroupManager.ADMIN_GROUPID, false);
    public static final PermissionID ALL_HOSTS_RUN_DIFF_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00013-0000000003", RemoteGroupManager.ADMIN_GROUPID, true);
    public static final PermissionID ALL_TASK_CONTROL_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00038-0000000003", RemoteGroupManager.ADMIN_GROUPID, false);
    public static final PermissionID ALL_FOLDERS_ACTIONS_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00029-0000000003", RemoteGroupManager.ADMIN_GROUPID, true);
    public static final PermissionID DIFF_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00014-0000000003", RemoteGroupManager.REGISTERED_GROUPID, true);
    public static final PermissionID DIFF_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00015-0000000003", RemoteGroupManager.ADMIN_GROUPID, true);
    public static final PermissionID SERVICE_REF_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00017-0000000003", RemoteGroupManager.REGISTERED_GROUPID, false);
    public static final PermissionID SERVICE_REF_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00018-0000000003", RemoteGroupManager.ADMIN_GROUPID, false);
    public static final PermissionID COMPONENT_TYPE_REF_READ_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00019-0000000003", RemoteGroupManager.REGISTERED_GROUPID, false);
    public static final PermissionID COMPONENT_TYPE_REF_WRITE_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00020-0000000003", RemoteGroupManager.ADMIN_GROUPID, false);
    public static final PermissionID AUTOGEN_FOLDER_EXECUTE_ALL_PERMISSIONID = RemotePermissionManager.newPermissionID("010010001024-0000000000000-00034-0000000003", RemoteGroupManager.REGISTERED_GROUPID, true);
    private static final GroupID[] EMPTY_GROUPS = new GroupID[0];

    RemotePermissionManager(RemoteUserDBAdmin remoteAdmin) {
        this.setRemoteAdmin(remoteAdmin);
    }

    private RemoteUserDBAdmin getRemoteAdmin() {
        return this.m_remoteAdmin;
    }

    private void setRemoteAdmin(RemoteUserDBAdmin remoteAdmin) {
        this.m_remoteAdmin = remoteAdmin;
        this.setPermissionManagerService(remoteAdmin.getPermissionManagerService());
    }

    private PermissionManagerService getPermissionManagerService() {
        return this.mPermissionManagerService;
    }

    private void setPermissionManagerService(PermissionManagerService permissionManagerService) {
        this.mPermissionManagerService = permissionManagerService;
    }

    public Permission newPermission() {
        return new RemotePermission(this.getRemoteAdmin());
    }

    public Permission getPermission(PermissionID permissionID) throws UserDBException, RPCException {
        PermissionData data = this.getPermissionManagerService().getPermissionData(permissionID);
        return new RemotePermission(this.getRemoteAdmin(), permissionID, data);
    }

    public void deletePermission(PermissionID permissionID) throws RPCException, UserDBException {
        if (permissionID == null) {
            throw new UserDBException(MSG_DELETE_NULL_PERMISSIONID);
        }
        this.getPermissionManagerService().delete(permissionID);
    }

    public Permission[] getAllPermissions() throws UserDBException, RPCException {
        RemoteObject[] result = this.getPermissionManagerService().getAllPermissions();
        this.getRemoteAdmin().register(result);
        return result;
    }

    public PermissionID[] getAllSystemPermissions() throws UserDBException, RPCException {
        return sSystemPermissions.toArray(new PermissionID[sSystemPermissions.size()]);
    }

    public Permission[] getPermissionsByUser(UserID userID) throws UserDBException, RPCException {
        RemoteObject[] result = this.getPermissionManagerService().getPermissionsByUser(userID);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public Permission[] getPermissionsByCriteria(String namePattern, String classNamePattern, String actionsPattern) throws UserDBException, RPCException {
        RemoteObject[] result = this.getPermissionManagerService().getPermissionsByCriteria(namePattern, classNamePattern, actionsPattern);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public boolean checkPermission(UserID userID, Permission permission) throws UserDBException, RPCException {
        String className = permission.getClassName();
        String name = permission.getName();
        String actions = permission.getActions();
        return this.getPermissionManagerService().checkPermission(userID, className, name, actions);
    }

    public PermissionID getUserDBReadPermissionID() {
        return USERDB_READ_PERMISSIONID;
    }

    public PermissionID getUserDBWritePermissionID() {
        return USERDB_WRITE_PERMISSIONID;
    }

    public PermissionID getHostReadPermissionID() {
        return HOST_READ_PERMISSIONID;
    }

    public PermissionID getHostWritePermissionID() {
        return HOST_WRITE_PERMISSIONID;
    }

    public PermissionID getHostTypeReadPermissionID() {
        return HOST_TYPE_READ_PERMISSIONID;
    }

    public PermissionID getHostTypeWritePermissionID() {
        return HOST_TYPE_WRITE_PERMISSIONID;
    }

    public PermissionID getRuleReadPermissionID() {
        return RULE_READ_PERMISSIONID;
    }

    public PermissionID getRuleWritePermissionID() {
        return RULE_WRITE_PERMISSIONID;
    }

    public PermissionID getPluginReadPermissionID() {
        return PLUGIN_READ_PERMISSIONID;
    }

    public PermissionID getPluginWritePermissionID() {
        return PLUGIN_WRITE_PERMISSIONID;
    }

    public PermissionID getAllHostsRunDiffPermissionID() {
        return ALL_HOSTS_RUN_DIFF_PERMISSIONID;
    }

    public PermissionID getAllTaskControlPermissionID() {
        return ALL_TASK_CONTROL_PERMISSIONID;
    }

    public PermissionID getAllFolderAllActionsPermissionID() {
        return ALL_FOLDERS_ACTIONS_PERMISSIONID;
    }

    public PermissionID getDiffReadPermissionID() {
        return DIFF_READ_PERMISSIONID;
    }

    public PermissionID getDiffWritePermissionID() {
        return DIFF_WRITE_PERMISSIONID;
    }

    public PermissionID getSystemServiceRefReadPermissionID() {
        return SERVICE_REF_READ_PERMISSIONID;
    }

    public PermissionID getSystemServiceRefWritePermissionID() {
        return SERVICE_REF_WRITE_PERMISSIONID;
    }

    public PermissionID getComponentTypeRefReadPermissionID() {
        return COMPONENT_TYPE_REF_READ_PERMISSIONID;
    }

    public PermissionID getComponentTypeRefWritePermissionID() {
        return COMPONENT_TYPE_REF_WRITE_PERMISSIONID;
    }

    public PermissionID getAutogenFolderExecuteAllPermissionID() {
        return AUTOGEN_FOLDER_EXECUTE_ALL_PERMISSIONID;
    }

    public GroupID[] getDefaultGroups(PermissionID permissionID) {
        return RemotePermissionManager.getRegisteredGroups(permissionID).toArray(EMPTY_GROUPS);
    }

    static Set getRegisteredGroups(PermissionID permID) {
        Set result = (Set)sRegisteredGroups.get(permID);
        if (result == null) {
            result = EMPTY_SET;
        }
        return result;
    }

    private static void registerGroup(PermissionID permID, GroupID groupID) {
        HashSet<GroupID> groups = (HashSet<GroupID>)sRegisteredGroups.get(permID);
        if (groups == null) {
            groups = new HashSet<GroupID>();
            sRegisteredGroups.put(permID, groups);
        }
        groups.add(groupID);
    }

    static boolean isSystemPermission(PermissionID permissionID) {
        return sSystemPermissions.contains(permissionID);
    }

    static boolean isVisiblePermission(PermissionID permissionID) {
        return sVisiblePermissions.contains(permissionID);
    }

    private static PermissionID newPermissionID(String ID2, GroupID defaultGroup, boolean isVisible) {
        PermissionID result = new PermissionID(ID2);
        RemoteGroupManager.registerPermission(defaultGroup, result);
        RemotePermissionManager.registerGroup(result, defaultGroup);
        sSystemPermissions.add(result);
        if (isVisible) {
            sVisiblePermissions.add(result);
        }
        return result;
    }
}

