/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionData;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionService;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteObject;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;

class RemotePermission
extends RemoteObject
implements Permission {
    private transient PermissionService m_permissionService;
    private PermissionID m_permissionID;
    private transient RemoteGroup[] m_groups;
    private transient boolean m_groupsIsDirty;
    private PermissionData m_permissionData = null;

    private RemotePermission() {
    }

    RemotePermission(RemoteUserDBAdmin remoteAdmin) {
        super(remoteAdmin);
        this.setPermissionData(new PermissionData());
    }

    RemotePermission(RemoteUserDBAdmin remoteAdmin, PermissionID permissionID, PermissionData permissionData) {
        super(remoteAdmin);
        this.setPermissionID(permissionID);
        this.setPermissionData(permissionData);
    }

    RemotePermission(PermissionID permissionID, PermissionData permissionData) {
        this.setPermissionID(permissionID);
        this.setPermissionData(permissionData);
    }

    void setRemoteAdmin(RemoteUserDBAdmin remoteAdmin) {
        super.setRemoteAdmin(remoteAdmin);
        this.setPermissionService(remoteAdmin.getPermissionService());
    }

    private PermissionService getPermissionService() {
        return this.m_permissionService;
    }

    private void setPermissionService(PermissionService permissionService) {
        this.m_permissionService = permissionService;
    }

    public PermissionID getPermissionID() {
        return this.m_permissionID;
    }

    private void setPermissionID(PermissionID permissionID) {
        this.m_permissionID = permissionID;
    }

    public int getUpdateCount() {
        return this.getPermissionData().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getPermissionData().setUpdateCount(updateCount);
    }

    public String getName() {
        return this.getPermissionData().getName();
    }

    public void setName(String name) {
        this.getPermissionData().setName(name);
    }

    public String getClassName() {
        return this.getPermissionData().getClassName();
    }

    public void setClassName(String className) {
        this.getPermissionData().setClassName(className);
    }

    public String getActions() {
        return this.getPermissionData().getActions();
    }

    public void setActions(String actions) {
        this.getPermissionData().setActions(actions);
    }

    public Group[] getGroups() throws RPCException, UserDBException {
        PermissionID id;
        if (this.m_groups == null && (id = this.getPermissionID()) != null) {
            RemoteObject[] groups = this.getPermissionService().getGroups(id);
            this.getRemoteAdmin().register(groups);
            this.m_groups = groups;
        }
        return this.m_groups;
    }

    public void setGroups(Group[] groups) {
        if (groups instanceof RemoteGroup[]) {
            this.m_groups = (RemoteGroup[])groups;
        } else {
            RemoteGroup[] remoteGroups = new RemoteGroup[groups.length];
            System.arraycopy(groups, 0, remoteGroups, 0, groups.length);
            this.m_groups = remoteGroups;
        }
        this.m_groupsIsDirty = true;
    }

    public void save() throws RPCException, UserDBException {
        if (FolderPermission.class.getName().equals(this.getClassName())) {
            throw new UserDBException("userdb.CANNOT_SAVE_FOLDER_PERM", this.toString());
        }
        PermissionID permissionID = this.getPermissionID();
        PermissionData permissionData = this.getPermissionData();
        GroupID[] groups = null;
        if (this.m_groupsIsDirty) {
            groups = this.getRemoteAdmin().toIDs(this.m_groups);
        }
        permissionID = this.getPermissionService().save(permissionID, permissionData, groups);
        this.setPermissionID(permissionID);
        this.incrementUpdateCount();
        this.m_groupsIsDirty = false;
    }

    public boolean equals(Object other) {
        PermissionID thisPermissionID;
        if (other == this) {
            return true;
        }
        if (other != null && other instanceof Permission && (thisPermissionID = this.getPermissionID()) != null) {
            PermissionID otherPermissionID = ((Permission)other).getPermissionID();
            return thisPermissionID.equals(otherPermissionID);
        }
        return false;
    }

    public int hashCode() {
        PermissionID id = this.getPermissionID();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        PermissionID permissionID = this.getPermissionID();
        return "Permission:" + (permissionID != null ? permissionID.toString() : super.toString());
    }

    private PermissionData getPermissionData() {
        return this.m_permissionData;
    }

    private void setPermissionData(PermissionData permissionData) {
        this.m_permissionData = permissionData;
    }
}

