/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteObject;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class RemoteGroupManager
implements GroupManager {
    private RemoteUserDBAdmin m_remoteAdmin;
    private GroupManagerService m_groupManagerService;
    public static final GroupID ADMIN_GROUPID = new GroupID("010010001024-0000000000000-00001-0000000002");
    public static final GroupID REGISTERED_GROUPID = new GroupID("010010001024-0000000000000-00002-0000000002");
    public static final GroupID UNIVERSAL_GROUPID = new GroupID("010010001024-0000000000000-00003-0000000002");
    private static final PermissionID[] EMPTY_PERMS = new PermissionID[0];
    private static final Set EMPTY_SET = new HashSet();
    private static final HashMap sRegisteredPermissions = new HashMap();

    RemoteGroupManager(RemoteUserDBAdmin remoteAdmin) {
        this.setRemoteAdmin(remoteAdmin);
    }

    private RemoteUserDBAdmin getRemoteAdmin() {
        return this.m_remoteAdmin;
    }

    private void setRemoteAdmin(RemoteUserDBAdmin remoteAdmin) {
        this.m_remoteAdmin = remoteAdmin;
        this.setGroupManagerService(remoteAdmin.getGroupManagerService());
    }

    private GroupManagerService getGroupManagerService() {
        return this.m_groupManagerService;
    }

    private void setGroupManagerService(GroupManagerService groupManagerService) {
        this.m_groupManagerService = groupManagerService;
    }

    public Group newGroup() {
        return new RemoteGroup(this.getRemoteAdmin());
    }

    public Group getGroup(GroupID groupID) throws UserDBException, RPCException {
        return new RemoteGroup(this.getRemoteAdmin(), groupID, this.getGroupManagerService().getGroupData(groupID));
    }

    public Group getGroup(String groupName) throws UserDBException, RPCException {
        RemoteGroup result = this.getGroupManagerService().getGroup(groupName);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public Group[] getGroupsByUser(UserID userID) throws RPCException, UserDBException {
        RemoteObject[] result = this.getGroupManagerService().getGroupsByUser(userID);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public Group[] getGroupsByCriteria(String namePattern, String descriptionPattern, String typePattern) throws RPCException, UserDBException {
        RemoteObject[] result = this.getGroupManagerService().getGroupsByCriteria(namePattern, descriptionPattern, typePattern);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public User[] getGroupMembers(GroupID groupID) throws RPCException, UserDBException {
        RemoteObject[] result = this.getGroupManagerService().getGroupMembers(groupID);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public boolean isGroupMember(GroupID groupID, UserID userID) throws RPCException, UserDBException {
        return this.getGroupManagerService().isGroupMember(groupID, userID);
    }

    public Permission[] getGrantedPermissions(GroupID groupID) throws RPCException, UserDBException {
        RemoteObject[] result = this.getGroupManagerService().getGrantedPermissions(groupID);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public boolean isGrantedPermission(GroupID groupID, PermissionID permissionID) throws RPCException, UserDBException {
        return this.getGroupManagerService().isGrantedPermission(groupID, permissionID);
    }

    public Group[] getDescendantGroups(GroupID groupID) throws RPCException, UserDBException {
        RemoteObject[] result = this.getGroupManagerService().getDescendantGroups(groupID);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public Group[] getAncestorGroups(GroupID groupID) throws RPCException, UserDBException {
        RemoteObject[] result = this.getGroupManagerService().getAncestorGroups(groupID);
        this.getRemoteAdmin().register(result);
        return result;
    }

    public boolean isGroupDescendant(GroupID parentGroupID, GroupID childGroupID) throws RPCException, UserDBException {
        return this.getGroupManagerService().isGroupDescendant(parentGroupID, childGroupID);
    }

    public GroupID getAdminGroupID() {
        return ADMIN_GROUPID;
    }

    public GroupID getRegisteredGroupID() {
        return REGISTERED_GROUPID;
    }

    public GroupID getUniversalGroupID() {
        return UNIVERSAL_GROUPID;
    }

    static boolean isSystemGroup(GroupID groupID) {
        return ADMIN_GROUPID.equals(groupID) || REGISTERED_GROUPID.equals(groupID) || UNIVERSAL_GROUPID.equals(groupID);
    }

    public PermissionID[] getDefaultPermissions(GroupID groupID) {
        return RemoteGroupManager.getRegisteredPermissions(groupID).toArray(EMPTY_PERMS);
    }

    static Set getRegisteredPermissions(GroupID groupID) {
        Set result = (Set)sRegisteredPermissions.get(groupID);
        if (result == null) {
            result = EMPTY_SET;
        }
        return result;
    }

    static void registerPermission(GroupID groupID, PermissionID permID) {
        HashSet<PermissionID> perms = (HashSet<PermissionID>)sRegisteredPermissions.get(groupID);
        if (perms == null) {
            perms = new HashSet<PermissionID>();
            sRegisteredPermissions.put(groupID, perms);
        }
        perms.add(permID);
    }
}

