/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupData;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupService;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteObject;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermission;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUser;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

class RemoteGroup
extends RemoteObject
implements Group,
HasObjectID,
UsingObject {
    private transient GroupService m_groupService;
    private GroupID m_groupID;
    private RemoteUser[] m_users;
    private transient boolean m_usersIsDirty;
    private RemotePermission[] m_permissions;
    private transient boolean m_permissionsIsDirty;
    private transient RemoteGroup[] m_parentGroups;
    private transient boolean m_parentGroupsIsDirty;
    private transient RemoteGroup[] m_childGroups;
    private transient boolean m_childGroupsIsDirty;
    private GroupData m_groupData = null;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission;

    RemoteGroup(RemoteUserDBAdmin remoteAdmin) {
        super(remoteAdmin);
        this.setGroupData(new GroupData());
    }

    RemoteGroup(RemoteUserDBAdmin remoteAdmin, GroupID groupID, GroupData groupData) {
        this(remoteAdmin);
        this.setGroupID(groupID);
        this.setGroupData(groupData);
    }

    RemoteGroup(GroupID groupID, GroupData groupData) {
        this.setGroupID(groupID);
        this.setGroupData(groupData);
    }

    private RemoteGroup() {
    }

    void setRemoteAdmin(RemoteUserDBAdmin remoteAdmin) {
        super.setRemoteAdmin(remoteAdmin);
        this.setGroupService(remoteAdmin.getGroupService());
    }

    private GroupService getGroupService() {
        return this.m_groupService;
    }

    private void setGroupService(GroupService groupService) {
        this.m_groupService = groupService;
    }

    public ObjectID getObjectID() {
        return this.m_groupID;
    }

    public GroupID getGroupID() {
        return this.m_groupID;
    }

    private void setGroupID(GroupID groupID) {
        this.m_groupID = groupID;
    }

    public int getUpdateCount() {
        return this.getGroupData().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getGroupData().setUpdateCount(updateCount);
    }

    public String getName() {
        return this.getGroupData().getName();
    }

    public void setName(String name) {
        this.getGroupData().setName(name);
    }

    public String getDescription() {
        return this.getGroupData().getDescription();
    }

    public void setDescription(String description) {
        this.getGroupData().setDescription(description);
    }

    public String getType() {
        return this.getGroupData().getType();
    }

    public void setType(String type) {
        this.getGroupData().setType(type);
    }

    public User[] getUsers() throws RPCException, UserDBException {
        GroupID id;
        if (this.m_users == null && (id = this.getGroupID()) != null) {
            RemoteObject[] users = this.getGroupService().getUsers(id);
            this.getRemoteAdmin().register(users);
            this.m_users = users;
        }
        return this.m_users;
    }

    public void setUsers(User[] users) {
        if (users instanceof RemoteUser[]) {
            this.m_users = (RemoteUser[])users;
        } else {
            RemoteUser[] remoteUsers = new RemoteUser[users.length];
            System.arraycopy(users, 0, remoteUsers, 0, users.length);
            this.m_users = remoteUsers;
        }
        this.m_usersIsDirty = true;
    }

    public Permission[] getPermissions() throws RPCException, UserDBException {
        GroupID id;
        if (this.m_permissions == null && (id = this.getGroupID()) != null) {
            RemoteObject[] permissions = this.getGroupService().getPermissions(id);
            this.getRemoteAdmin().register(permissions);
            this.m_permissions = permissions;
        }
        return this.m_permissions;
    }

    public void setPermissions(Permission[] permissions) {
        if (permissions instanceof RemotePermission[]) {
            this.m_permissions = (RemotePermission[])permissions;
        } else {
            RemotePermission[] remotePermissions = new RemotePermission[permissions.length];
            System.arraycopy(permissions, 0, remotePermissions, 0, permissions.length);
            this.m_permissions = remotePermissions;
        }
        this.m_permissionsIsDirty = true;
    }

    public Group[] getParentGroups() throws RPCException, UserDBException {
        GroupID id;
        if (this.m_parentGroups == null && (id = this.getGroupID()) != null) {
            RemoteObject[] parentGroups = this.getGroupService().getParentGroups(id);
            this.getRemoteAdmin().register(parentGroups);
            this.m_parentGroups = parentGroups;
        }
        return this.m_parentGroups;
    }

    public void setParentGroups(Group[] parentGroups) {
        if (parentGroups instanceof RemoteGroup[]) {
            this.m_parentGroups = (RemoteGroup[])parentGroups;
        } else {
            RemoteGroup[] remoteParentGroups = new RemoteGroup[parentGroups.length];
            System.arraycopy(parentGroups, 0, remoteParentGroups, 0, parentGroups.length);
            this.m_parentGroups = remoteParentGroups;
        }
        this.m_parentGroupsIsDirty = true;
    }

    public Group[] getChildGroups() throws RPCException, UserDBException {
        GroupID id;
        if (this.m_childGroups == null && (id = this.getGroupID()) != null) {
            RemoteObject[] childGroups = this.getGroupService().getChildGroups(id);
            this.getRemoteAdmin().register(childGroups);
            this.m_childGroups = childGroups;
        }
        return this.m_childGroups;
    }

    public void setChildGroups(Group[] childGroups) {
        if (childGroups instanceof RemoteGroup[]) {
            this.m_childGroups = (RemoteGroup[])childGroups;
        } else {
            RemoteGroup[] remoteChildGroups = new RemoteGroup[childGroups.length];
            System.arraycopy(childGroups, 0, remoteChildGroups, 0, childGroups.length);
            this.m_childGroups = remoteChildGroups;
        }
        this.m_childGroupsIsDirty = true;
    }

    public void save() throws RPCException, UserDBException {
        GroupID groupID = this.getGroupID();
        GroupData groupData = this.getGroupData();
        UserID[] users = null;
        if (this.m_usersIsDirty) {
            users = this.getRemoteAdmin().toIDs(this.m_users);
        }
        PermissionID[] permissions = null;
        if (this.m_permissionsIsDirty) {
            for (int i = 0; i < this.m_permissions.length; ++i) {
                RemotePermission permission = this.m_permissions[i];
                if (!(class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? RemoteGroup.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission") : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName().equals(permission.getClassName())) continue;
                throw new UserDBException("userdb.CANNOT_INCLUDE_FOLDER_PERM", permission.toString());
            }
            permissions = this.getRemoteAdmin().toIDs(this.m_permissions);
        }
        GroupID[] parentGroups = null;
        if (this.m_parentGroupsIsDirty) {
            parentGroups = this.getRemoteAdmin().toIDs(this.m_parentGroups);
        }
        GroupID[] childGroups = null;
        if (this.m_childGroupsIsDirty) {
            childGroups = this.getRemoteAdmin().toIDs(this.m_childGroups);
        }
        groupID = this.getGroupService().save(groupID, groupData, users, permissions, parentGroups, childGroups);
        this.setGroupID(groupID);
        this.incrementUpdateCount();
        this.m_permissionsIsDirty = false;
        this.m_usersIsDirty = false;
        this.m_parentGroupsIsDirty = false;
        this.m_childGroupsIsDirty = false;
    }

    public boolean equals(Object other) {
        GroupID thisGroupID;
        if (other == this) {
            return true;
        }
        if (other != null && other instanceof Group && (thisGroupID = this.getGroupID()) != null) {
            GroupID otherGroupID = ((Group)other).getGroupID();
            return thisGroupID.equals(otherGroupID);
        }
        return false;
    }

    public int hashCode() {
        GroupID id = this.getGroupID();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        GroupID groupID = this.getGroupID();
        return "Group:" + (groupID != null ? groupID.toString() : super.toString());
    }

    private GroupData getGroupData() {
        return this.m_groupData;
    }

    private void setGroupData(GroupData groupData) {
        this.m_groupData = groupData;
    }
}

