/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.UserData;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

public class PersistentUserData
extends PersistentObject {
    public static final String USERNAME_PROPERTY = "Username";
    public static final String PASSWORD_PROPERTY = "Password";
    private String mUsername;
    private String mPassword;
    private boolean mActive;
    private String mLoginConfiguration = null;
    private boolean mSessionVarDetect = true;

    public PersistentUserData() {
    }

    public PersistentUserData(UserID userID) {
        if (userID != null) {
            this.setPersistent(true);
            this.setUserID(userID);
        }
    }

    public PersistentUserData(UserID userID, UserData userData) {
        this(userID);
        if (userData != null) {
            this.setUpdateCount(userData.getUpdateCount());
            this.setUsername(userData.getUsername());
            this.setPassword(this.toString(userData.getPassword()));
            this.setVisibility(userData.getVisibility());
            this.setActive(userData.getActive());
            this.setLoginConfiguration(userData.getLoginConfiguration());
            this.setSessionVarDetect(!userData.isClearSessionVarsOnLoginConfigChange());
        }
    }

    private String toString(HashedString s) {
        return s == null ? null : s.toString();
    }

    private HashedString toHashedString(String s) {
        return s == null ? null : new HashedString(s);
    }

    public void setObjectID(ObjectID id) {
        this.setUserID((UserID)id);
    }

    public UserID getUserID() {
        return (UserID)this.getObjectID();
    }

    public void setUserID(UserID userID) {
        super.setObjectID(userID);
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public boolean getActive() {
        return this.mActive;
    }

    public void setActive(boolean inActive) {
        this.mActive = inActive;
    }

    public String getLoginConfiguration() {
        return this.mLoginConfiguration;
    }

    public void setLoginConfiguration(String inLoginConfiguration) {
        this.mLoginConfiguration = inLoginConfiguration;
    }

    public boolean isSessionVarDetect() {
        return this.mSessionVarDetect;
    }

    private void setSessionVarDetect(boolean inSessionVarDetect) {
        this.mSessionVarDetect = inSessionVarDetect;
    }

    public UserData toUserData() {
        UserData result = new UserData();
        result.setUpdateCount(this.getUpdateCount());
        result.setUsername(this.getUsername());
        result.setPassword(this.toHashedString(this.getPassword()));
        result.setVisibility(this.getVisibility());
        result.setActive(this.getActive());
        result.setLoginConfiguration(this.getLoginConfiguration());
        result.setIsClearSessionVarsOnLoginConfigChange(!this.isSessionVarDetect());
        return result;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        public ObjectID newInstance(String id) {
            return new UserID(id);
        }

        public UserID generateUserID() {
            return (UserID)this.generateObjectID();
        }
    }
}

