/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionData;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;

public class PersistentPermissionData
extends PersistentObject {
    public static final String NAME_PROPERTY = "Name";
    public static final String CLASS_NAME_PROPERTY = "ClassName";
    public static final String ACTIONS_PROPERTY = "Actions";
    private String mName;
    private String mClassName;
    private String mActions;

    public PersistentPermissionData() {
    }

    public PersistentPermissionData(PermissionID permissionID) {
        if (permissionID != null) {
            this.setPersistent(true);
            this.setPermissionID(permissionID);
        }
    }

    public PersistentPermissionData(PermissionID permissionID, PermissionData permissionData) {
        this(permissionID);
        if (permissionData != null) {
            this.setUpdateCount(permissionData.getUpdateCount());
            this.setName(permissionData.getName());
            this.setClassName(permissionData.getClassName());
            this.setActions(permissionData.getActions());
        }
    }

    public void setObjectID(ObjectID id) {
        this.setPermissionID((PermissionID)id);
    }

    public PermissionID getPermissionID() {
        return (PermissionID)this.getObjectID();
    }

    public void setPermissionID(PermissionID permissionID) {
        super.setObjectID(permissionID);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public void setClassName(String className) {
        this.mClassName = className;
    }

    public String getActions() {
        return this.mActions;
    }

    public void setActions(String actions) {
        this.mActions = actions;
    }

    public PermissionData toPermissionData() {
        PermissionData result = new PermissionData();
        result.setUpdateCount(this.getUpdateCount());
        result.setName(this.getName());
        result.setClassName(this.getClassName());
        result.setActions(this.getActions());
        return result;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        public ObjectID newInstance(String id) {
            return new PermissionID(id);
        }

        public PermissionID generatePermissionID() {
            return (PermissionID)this.generateObjectID();
        }
    }
}

