/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupData;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;

public class PersistentGroupData
extends PersistentObject {
    public static final String NAME_PROPERTY = "Name";
    public static final String DESCRIPTION_PROPERTY = "Description";
    public static final String TYPE_PROPERTY = "Type";
    private String m_name;
    private String m_description;
    private String mType;

    public PersistentGroupData() {
    }

    public PersistentGroupData(GroupID groupID) {
        if (groupID != null) {
            this.setPersistent(true);
            this.setGroupID(groupID);
        }
    }

    public PersistentGroupData(GroupID groupID, GroupData groupData) {
        this(groupID);
        if (groupData != null) {
            this.setUpdateCount(groupData.getUpdateCount());
            this.setName(groupData.getName());
            this.setDescription(groupData.getDescription());
            this.setType(groupData.getType());
        }
    }

    public void setObjectID(ObjectID id) {
        this.setGroupID((GroupID)id);
    }

    public GroupID getGroupID() {
        return (GroupID)this.getObjectID();
    }

    public void setGroupID(GroupID groupID) {
        super.setObjectID(groupID);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public GroupData toGroupData() {
        GroupData result = new GroupData();
        result.setUpdateCount(this.getUpdateCount());
        result.setName(this.getName());
        result.setDescription(this.getDescription());
        result.setType(this.getType());
        return result;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        public ObjectID newInstance(String id) {
            return new GroupID(id);
        }

        public GroupID generateGroupID() {
            return (GroupID)this.generateObjectID();
        }
    }
}

