/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GrantedPermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentPermissionData;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentPermissionDataTable;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

class PermissionTable
extends PersistentPermissionDataTable {
    private static final GrantedPermissionTable GPT = new GrantedPermissionTable("gpT");
    public static final PermissionTable DEFAULT = new PermissionTable(null);

    public PermissionTable(String alias) {
        super(alias);
    }

    public RemotePermission[] execute(Select query) throws UserDBException {
        if (query == null) {
            return null;
        }
        try {
            PersistentBean[] perms = PermissionTable.executeMultiResult(query, this);
            RemotePermission[] result = new RemotePermission[perms.length];
            for (int i = 0; i < perms.length; ++i) {
                PersistentPermissionData perm = (PersistentPermissionData)perms[i];
                result[i] = new RemotePermission(perm.getPermissionID(), perm.toPermissionData());
            }
            return result;
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    public RemotePermission[] executeSelectAll() throws UserDBException {
        return this.execute(this.select());
    }

    public RemotePermission[] executeSelectByCriteria(String namePattern, String classNamePattern, String actionsPattern) throws UserDBException {
        return this.execute(this.selectByCriteria(namePattern, classNamePattern, actionsPattern));
    }

    public Select selectByCriteria(String namePattern, String classNamePattern, String actionsPattern) {
        if (namePattern == null && classNamePattern == null && actionsPattern == null) {
            return null;
        }
        return this.select(PermissionTable.where(this.getPatternExpr(namePattern, classNamePattern, actionsPattern)));
    }

    Select selectIDByCriteria(String namePattern, String classNamePattern, String actionsPattern) {
        if (namePattern == null && classNamePattern == null && actionsPattern == null) {
            return null;
        }
        return PermissionTable.select(PermissionTable.sList(this.ID), PermissionTable.tList(this), PermissionTable.where(this.getPatternExpr(namePattern, classNamePattern, actionsPattern)));
    }

    private AndExp getPatternExpr(String namePattern, String classNamePattern, String actionsPattern) {
        AndExp where = PermissionTable.and();
        if (namePattern != null) {
            where.add(PermissionTable.like(this.Name, namePattern));
        }
        if (classNamePattern != null) {
            where.add(PermissionTable.like(this.ClassName, classNamePattern));
        }
        if (actionsPattern != null) {
            where.add(PermissionTable.like(this.Actions, actionsPattern));
        }
        return where;
    }

    public RemotePermission[] executeSelectByGroup(GroupID groupID, String excludeClassNamePattern) throws UserDBException {
        return this.execute(this.selectByGroup(groupID, excludeClassNamePattern));
    }

    public Select selectByGroup(GroupID groupID, String excludeClassNamePattern) {
        GrantedPermissionTable gpt = GrantedPermissionTable.DEFAULT;
        AndExp andExpr = PermissionTable.and();
        andExpr.add(PermissionTable.in((ColumnNode)this.ID, gpt.selectPermissionsByGroup(groupID)));
        this.excludeClassName(excludeClassNamePattern, andExpr);
        return this.select(PermissionTable.where(andExpr));
    }

    private void excludeClassName(String excludeClassNamePattern, AndExp inAndExpr) {
        if (excludeClassNamePattern != null) {
            inAndExpr.add(PermissionTable.not(PermissionTable.like(this.ClassName, excludeClassNamePattern)));
        }
    }

    public RemotePermission[] executeSelectByGroupAncestors(GroupID groupID) throws UserDBException {
        return this.execute(this.selectByGroupAncestors(groupID));
    }

    public Select selectByGroupAncestors(GroupID groupID) {
        GrantedPermissionTable gpt = GrantedPermissionTable.DEFAULT;
        return this.select(PermissionTable.where(PermissionTable.in((ColumnNode)this.ID, gpt.selectPermissionsByGroupAncestors(groupID))));
    }

    public RemotePermission[] executeSelectByUser(UserID userID) throws UserDBException {
        return this.execute(this.selectByUser(userID));
    }

    public Select selectByUser(UserID userID) throws UserDBException {
        return PermissionTable.select(this.allColumns(), PermissionTable.tList(this, (TableClause)GPT), PermissionTable.where(GPT.selectPermissionsByUser(userID, this)));
    }

    public int updatePermissionsByGroup(GroupID groupID, String excludeClassNamePattern) throws PersistenceManagerException {
        GrantedPermissionTable gpt = GrantedPermissionTable.DEFAULT;
        Select permIDs = gpt.selectPermissionsByGroup(groupID);
        AndExp andExp = PermissionTable.and();
        andExp.add(PermissionTable.in((ColumnNode)this.ID, permIDs));
        this.excludeClassName(excludeClassNamePattern, andExp);
        return PermissionTable.execute(this.update(PermissionTable.uList(PermissionTable.increment(this.UpdateCount)), PermissionTable.where(andExp)));
    }

    public int updatePermissionsByID(PermissionID[] permissionIDs) throws PersistenceManagerException {
        return PermissionTable.execute(this.update(PermissionTable.uList(PermissionTable.increment(this.UpdateCount)), PermissionTable.where(PermissionTable.in((ColumnNode)this.ID, PermissionTable.rList(permissionIDs)))));
    }

    Select selectID(String excludeClassNamePattern) {
        return PermissionTable.select(PermissionTable.sList(this.ID), PermissionTable.tList(this), PermissionTable.where(PermissionTable.not(PermissionTable.like(this.ClassName, excludeClassNamePattern))));
    }

    public int deleteByPermPattern(String inNamePattern, String inClassNamePattern, String inActionPattern) throws PersistenceManagerException {
        return PermissionTable.execute(this.delete(PermissionTable.where(this.getPatternExpr(inNamePattern, inClassNamePattern, inActionPattern))));
    }

    public RemotePermission[] executeSelectByMultipleNames(String[] namePatterns, String classNamePattern) throws UserDBException {
        return this.execute(this.selectByMultipleNames(namePatterns, classNamePattern));
    }

    private Select selectByMultipleNames(String[] namePatterns, String classNamePattern) {
        OrExp orExp = PermissionTable.or();
        for (int i = 0; i < namePatterns.length; ++i) {
            orExp.add(PermissionTable.like(this.Name, namePatterns[i]));
        }
        return PermissionTable.select((SelectList)this.allColumns(), PermissionTable.tList(this), PermissionTable.where(PermissionTable.and(PermissionTable.like(this.ClassName, classNamePattern), orExp)), PermissionTable.oList(PermissionTable.orderByAsc(this.Name)));
    }

    public RemotePermission[] executeSelectGranted(GroupID inGroupID, String inNamePattern, String inClassNamePattern, String inActionPattern) throws UserDBException {
        AndExp and = this.getPatternExpr(inNamePattern, inClassNamePattern, inActionPattern);
        and.add(PermissionTable.in((ColumnNode)this.ID, GrantedPermissionTable.DEFAULT.selectPermissionsByGroup(inGroupID)));
        return this.execute(this.select(PermissionTable.where(and)));
    }

    public RemotePermission[] executeSelectByCriteria(String inNamePattern, String inClassNamePattern, String inActionPattern, ConditionalExpression inExpression) throws UserDBException {
        AndExp and = this.getPatternExpr(inNamePattern, inClassNamePattern, inActionPattern);
        if (inExpression != null) {
            and.add(inExpression);
        }
        return this.execute(this.select(PermissionTable.where(and)));
    }
}

