/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.GrantedPermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.InvalidChangeException;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionData;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionEvent;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionListener;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionService;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentPermissionData;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermission;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

class PermissionServicesImpl
implements PermissionManagerService,
PermissionService {
    private static final String MSG_SYSTEM_PERMISSION_DELETE = "userdb.psi.SYSTEM_PERMISSION_DELETE";
    private static final String MSG_DEFAULT_GROUP_REMOVE = "userdb.psi.DEFAULT_GROUP_REMOVE";
    private static final String MSG_SYSTEM_CLASS_NAME_CHANGED = "userdb.psi.SYSTEM_CLASS_NAME_CHANGED";
    private static final String MSG_SYSTEM_NAME_CHANGED = "userdb.psi.SYSTEM_NAME_CHANGED";
    private static final String MSG_SYSTEM_ACTIONS_CHANGED = "userdb.psi.SYSTEM_ACTIONS_CHANGED";
    private static final PermissionTable NON_DEFAULT_PERMISSION_TABLE = new PermissionTable("pT");
    private AdminServicesManager mManager;
    private Vector mListeners = new Vector();

    PermissionServicesImpl(AdminServicesManager manager) {
        this.setManager(manager);
    }

    public AdminServicesManager getManager() {
        return this.mManager;
    }

    private void setManager(AdminServicesManager manager) {
        this.mManager = manager;
    }

    private GroupTable getGroupTable() {
        return GroupTable.DEFAULT;
    }

    private PermissionTable getPermissionTable() {
        return PermissionTable.DEFAULT;
    }

    private GrantedPermissionTable getGrantedPermissionTable() {
        return GrantedPermissionTable.DEFAULT;
    }

    private AccessControlManager getAccessControlManager() {
        return this.getManager().getAccessControlManager();
    }

    private Object transact(Transaction t) throws UserDBException {
        return this.getManager().transact(t);
    }

    public void addPermissionListener(PermissionListener listener) {
        this.mListeners.add(listener);
    }

    public void removePermissionListener(PermissionListener listener) {
        this.mListeners.remove(listener);
    }

    private void notifyPermissionAdded(PermissionID permissionID) throws InvalidChangeException {
        PermissionEvent event = new PermissionEvent(permissionID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((PermissionListener)listeners.nextElement()).permissionAdded(event);
        }
    }

    private void notifyPermissionModified(PermissionID permissionID) throws InvalidChangeException {
        PermissionEvent event = new PermissionEvent(permissionID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((PermissionListener)listeners.nextElement()).permissionModified(event);
        }
    }

    private void notifyPermissionRemoved(PermissionID permissionID) throws InvalidChangeException {
        PermissionEvent event = new PermissionEvent(permissionID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((PermissionListener)listeners.nextElement()).permissionRemoved(event);
        }
    }

    public RemotePermission[] getAllPermissions() throws UserDBException {
        return this.getPermissionTable().executeSelectAll();
    }

    public RemotePermission[] getPermissionsByUser(UserID userID) throws UserDBException {
        return NON_DEFAULT_PERMISSION_TABLE.executeSelectByUser(userID);
    }

    public RemotePermission[] getPermissionsByCriteria(String namePattern, String classNamePattern, String actionsPattern) throws UserDBException {
        PermissionTable pt = this.getPermissionTable();
        return pt.executeSelectByCriteria(namePattern, classNamePattern, actionsPattern);
    }

    public boolean checkPermission(UserID userID, String className, String name, String actions) throws RPCException, UserDBException {
        Application context = this.getManager().getUserDBSubsystem().getApplication();
        Permission perm = AccessControlManager.toJavaPermission(className, name, actions, context);
        AccessControlContext ctx = this.getAccessControlManager().getAccessControlContext(userID);
        try {
            ctx.checkPermission(perm);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public PermissionData getPermissionData(PermissionID permissionID) throws UserDBException {
        try {
            PersistentPermissionData result = new PersistentPermissionData(permissionID);
            result.retrieve();
            return result.toPermissionData();
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    public RemoteGroup[] getGroups(PermissionID permissionID) throws UserDBException {
        GroupTable gt = this.getGroupTable();
        return gt.executeSelectByPermission(permissionID);
    }

    public PermissionID save(final PermissionID permID, final PermissionData permData, final GroupID[] groups) throws UserDBException {
        if (permID == null || permData != null) {
            this.validate(permData);
        }
        if (RemotePermissionManager.isSystemPermission(permID)) {
            if (groups != null) {
                this.verifyContainsDefaultGroups(permID, groups);
            }
            this.validateSystemPermission(permID, permData);
        }
        return (PermissionID)this.transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                return PermissionServicesImpl.this.transactSave(permID, permData, groups);
            }
        });
    }

    private void validate(PermissionData permData) throws UserDBException {
        String className = null;
        String name = null;
        String actions = null;
        if (permData != null) {
            className = permData.getClassName();
            name = permData.getName();
            actions = permData.getActions();
        }
        Application context = this.getManager().getUserDBSubsystem().getApplication();
        AccessControlManager.toJavaPermission(className, name, actions, context);
    }

    private void validateSystemPermission(PermissionID permID, PermissionData permData) throws UserDBException {
        PermissionData savedPerm = this.getPermissionData(permID);
        if (!savedPerm.getClassName().equals(permData.getClassName())) {
            throw new UserDBException(MSG_SYSTEM_CLASS_NAME_CHANGED, permID);
        }
        if (!this.equals(savedPerm.getName(), permData.getName())) {
            throw new UserDBException(MSG_SYSTEM_NAME_CHANGED, permID);
        }
        if (!this.equals(savedPerm.getActions(), permData.getActions())) {
            throw new UserDBException(MSG_SYSTEM_ACTIONS_CHANGED, permID);
        }
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void verifyContainsDefaultGroups(PermissionID perm, GroupID[] groups) throws UserDBException {
        Set defaultGroups = RemotePermissionManager.getRegisteredGroups(perm);
        if (!Arrays.asList(groups).containsAll(defaultGroups)) {
            throw new UserDBException(MSG_DEFAULT_GROUP_REMOVE);
        }
    }

    private PermissionID transactSave(PermissionID permID, PermissionData permData, GroupID[] groups) throws PersistenceManagerException {
        PersistentPermissionData pData;
        boolean isNew;
        boolean bl = isNew = permID == null;
        if (isNew) {
            pData = new PersistentPermissionData(permID, permData);
            pData.save();
            permID = pData.getPermissionID();
        }
        if (groups != null) {
            if (!isNew) {
                this.deleteGrantedPermissions(permID);
            }
            if (groups.length > 0) {
                this.insertGrantedPermissions(groups, permID);
            }
        }
        if (isNew) {
            this.notifyPermissionAdded(permID);
        } else {
            pData = new PersistentPermissionData(permID, permData);
            pData.save();
            this.notifyPermissionModified(permID);
        }
        return permID;
    }

    private void insertGrantedPermissions(GroupID[] groups, PermissionID perm) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByID(groups);
        this.getGrantedPermissionTable().insert(groups, perm);
    }

    public void delete(final PermissionID permissionID) throws UserDBException {
        if (RemotePermissionManager.isSystemPermission(permissionID)) {
            throw new UserDBException(MSG_SYSTEM_PERMISSION_DELETE);
        }
        PermissionData pData = this.getPermissionData(permissionID);
        if (FolderPermission.class.getName().equals(pData.getClassName())) {
            throw new UserDBException("userdb.CANNOT_DELETE_FOLDER_PERM", permissionID.toString());
        }
        this.transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                PermissionServicesImpl.this.transactDelete(permissionID);
                return null;
            }
        });
    }

    private void transactDelete(PermissionID permissionID) throws PersistenceManagerException {
        this.deleteGrantedPermissions(permissionID);
        new PersistentPermissionData(permissionID).delete();
        this.notifyPermissionRemoved(permissionID);
    }

    private void deleteGrantedPermissions(PermissionID permissionID) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByPermission(permissionID);
        this.getGrantedPermissionTable().deleteByPermission(permissionID);
    }
}

